/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.DeleteGcmChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteGcmChannelRequestMarshaller
implements Marshaller<Request<DeleteGcmChannelRequest>, DeleteGcmChannelRequest> {
    public Request<DeleteGcmChannelRequest> marshall(DeleteGcmChannelRequest deleteGcmChannelRequest) {
        if (deleteGcmChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteGcmChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteGcmChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteGcmChannelRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)deleteGcmChannelRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/channels/gcm";
        uriResourcePath = uriResourcePath.replace("{application-id}", deleteGcmChannelRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)deleteGcmChannelRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

