/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.DeleteCampaignRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteCampaignRequestMarshaller
implements Marshaller<Request<DeleteCampaignRequest>, DeleteCampaignRequest> {
    public Request<DeleteCampaignRequest> marshall(DeleteCampaignRequest deleteCampaignRequest) {
        if (deleteCampaignRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteCampaignRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteCampaignRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteCampaignRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)deleteCampaignRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/campaigns/{campaign-id}";
        uriResourcePath = uriResourcePath.replace("{application-id}", deleteCampaignRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)deleteCampaignRequest.getApplicationId()));
        uriResourcePath = uriResourcePath.replace("{campaign-id}", deleteCampaignRequest.getCampaignId() == null ? "" : StringUtils.fromString((String)deleteCampaignRequest.getCampaignId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

