/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.DeleteApnsChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteApnsChannelRequestMarshaller
implements Marshaller<Request<DeleteApnsChannelRequest>, DeleteApnsChannelRequest> {
    public Request<DeleteApnsChannelRequest> marshall(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        if (deleteApnsChannelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteApnsChannelRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteApnsChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteApnsChannelRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)deleteApnsChannelRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/channels/apns";
        uriResourcePath = uriResourcePath.replace("{application-id}", deleteApnsChannelRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)deleteApnsChannelRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

