/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.CreateSegmentRequest;
import com.amazonaws.services.pinpoint.model.WriteSegmentRequest;
import com.amazonaws.services.pinpoint.model.transform.WriteSegmentRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateSegmentRequestMarshaller
implements Marshaller<Request<CreateSegmentRequest>, CreateSegmentRequest> {
    public Request<CreateSegmentRequest> marshall(CreateSegmentRequest createSegmentRequest) {
        if (createSegmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateSegmentRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSegmentRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSegmentRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)createSegmentRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/segments";
        uriResourcePath = uriResourcePath.replace("{application-id}", createSegmentRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)createSegmentRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (createSegmentRequest.getWriteSegmentRequest() != null) {
                WriteSegmentRequest writeSegmentRequest = createSegmentRequest.getWriteSegmentRequest();
                WriteSegmentRequestJsonMarshaller.getInstance().marshall(writeSegmentRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

