/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.pinpoint.model.CreateImportJobRequest;
import com.amazonaws.services.pinpoint.model.ImportJobRequest;
import com.amazonaws.services.pinpoint.model.transform.ImportJobRequestJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateImportJobRequestMarshaller
implements Marshaller<Request<CreateImportJobRequest>, CreateImportJobRequest> {
    public Request<CreateImportJobRequest> marshall(CreateImportJobRequest createImportJobRequest) {
        if (createImportJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateImportJobRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createImportJobRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.POST);
        if (createImportJobRequest.getAccept() != null) {
            request.addHeader("accept", StringUtils.fromString((String)createImportJobRequest.getAccept()));
        }
        String uriResourcePath = "/v1/apps/{application-id}/jobs/import";
        uriResourcePath = uriResourcePath.replace("{application-id}", createImportJobRequest.getApplicationId() == null ? "" : StringUtils.fromString((String)createImportJobRequest.getApplicationId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            if (createImportJobRequest.getImportJobRequest() != null) {
                ImportJobRequest importJobRequest = createImportJobRequest.getImportJobRequest();
                ImportJobRequestJsonMarshaller.getInstance().marshall(importJobRequest, jsonWriter);
            }
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

