/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.services.pinpoint.model.APNSChannelRequest;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class APNSChannelRequestJsonUnmarshaller
implements Unmarshaller<APNSChannelRequest, JsonUnmarshallerContext> {
    private static APNSChannelRequestJsonUnmarshaller instance;

    APNSChannelRequestJsonUnmarshaller() {
    }

    public APNSChannelRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        APNSChannelRequest aPNSChannelRequest = new APNSChannelRequest();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("Certificate")) {
                aPNSChannelRequest.setCertificate(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("PrivateKey")) {
                aPNSChannelRequest.setPrivateKey(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return aPNSChannelRequest;
    }

    public static APNSChannelRequestJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new APNSChannelRequestJsonUnmarshaller();
        }
        return instance;
    }
}

