/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.services.pinpoint.model.ChannelType;
import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointBatchItem
implements Serializable {
    private String address;
    private Map<String, List<String>> attributes;
    private String channelType;
    private EndpointDemographic demographic;
    private String effectiveDate;
    private String endpointStatus;
    private String id;
    private EndpointLocation location;
    private Map<String, Double> metrics;
    private String optOut;
    private String requestId;
    private EndpointUser user;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public EndpointBatchItem withAddress(String address) {
        this.address = address;
        return this;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public EndpointBatchItem withAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
        return this;
    }

    public EndpointBatchItem addAttributesEntry(String key, List<String> value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, List<String>>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public EndpointBatchItem clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public EndpointBatchItem withChannelType(String channelType) {
        this.channelType = channelType;
        return this;
    }

    public void setChannelType(ChannelType channelType) {
        this.channelType = channelType.toString();
    }

    public EndpointBatchItem withChannelType(ChannelType channelType) {
        this.channelType = channelType.toString();
        return this;
    }

    public EndpointDemographic getDemographic() {
        return this.demographic;
    }

    public void setDemographic(EndpointDemographic demographic) {
        this.demographic = demographic;
    }

    public EndpointBatchItem withDemographic(EndpointDemographic demographic) {
        this.demographic = demographic;
        return this;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public EndpointBatchItem withEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    public String getEndpointStatus() {
        return this.endpointStatus;
    }

    public void setEndpointStatus(String endpointStatus) {
        this.endpointStatus = endpointStatus;
    }

    public EndpointBatchItem withEndpointStatus(String endpointStatus) {
        this.endpointStatus = endpointStatus;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EndpointBatchItem withId(String id) {
        this.id = id;
        return this;
    }

    public EndpointLocation getLocation() {
        return this.location;
    }

    public void setLocation(EndpointLocation location) {
        this.location = location;
    }

    public EndpointBatchItem withLocation(EndpointLocation location) {
        this.location = location;
        return this;
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    public EndpointBatchItem withMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
        return this;
    }

    public EndpointBatchItem addMetricsEntry(String key, Double value) {
        if (null == this.metrics) {
            this.metrics = new HashMap<String, Double>();
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metrics.put(key, value);
        return this;
    }

    public EndpointBatchItem clearMetricsEntries() {
        this.metrics = null;
        return this;
    }

    public String getOptOut() {
        return this.optOut;
    }

    public void setOptOut(String optOut) {
        this.optOut = optOut;
    }

    public EndpointBatchItem withOptOut(String optOut) {
        this.optOut = optOut;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public EndpointBatchItem withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public EndpointUser getUser() {
        return this.user;
    }

    public void setUser(EndpointUser user) {
        this.user = user;
    }

    public EndpointBatchItem withUser(EndpointUser user) {
        this.user = user;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddress() != null) {
            sb.append("Address: " + this.getAddress() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getChannelType() != null) {
            sb.append("ChannelType: " + this.getChannelType() + ",");
        }
        if (this.getDemographic() != null) {
            sb.append("Demographic: " + this.getDemographic() + ",");
        }
        if (this.getEffectiveDate() != null) {
            sb.append("EffectiveDate: " + this.getEffectiveDate() + ",");
        }
        if (this.getEndpointStatus() != null) {
            sb.append("EndpointStatus: " + this.getEndpointStatus() + ",");
        }
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: " + this.getLocation() + ",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: " + this.getMetrics() + ",");
        }
        if (this.getOptOut() != null) {
            sb.append("OptOut: " + this.getOptOut() + ",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: " + this.getRequestId() + ",");
        }
        if (this.getUser() != null) {
            sb.append("User: " + this.getUser());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getChannelType() == null ? 0 : this.getChannelType().hashCode());
        hashCode = 31 * hashCode + (this.getDemographic() == null ? 0 : this.getDemographic().hashCode());
        hashCode = 31 * hashCode + (this.getEffectiveDate() == null ? 0 : this.getEffectiveDate().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointStatus() == null ? 0 : this.getEndpointStatus().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getOptOut() == null ? 0 : this.getOptOut().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointBatchItem)) {
            return false;
        }
        EndpointBatchItem other = (EndpointBatchItem)obj;
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getChannelType() == null ^ this.getChannelType() == null) {
            return false;
        }
        if (other.getChannelType() != null && !other.getChannelType().equals(this.getChannelType())) {
            return false;
        }
        if (other.getDemographic() == null ^ this.getDemographic() == null) {
            return false;
        }
        if (other.getDemographic() != null && !other.getDemographic().equals(this.getDemographic())) {
            return false;
        }
        if (other.getEffectiveDate() == null ^ this.getEffectiveDate() == null) {
            return false;
        }
        if (other.getEffectiveDate() != null && !other.getEffectiveDate().equals(this.getEffectiveDate())) {
            return false;
        }
        if (other.getEndpointStatus() == null ^ this.getEndpointStatus() == null) {
            return false;
        }
        if (other.getEndpointStatus() != null && !other.getEndpointStatus().equals(this.getEndpointStatus())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getOptOut() == null ^ this.getOptOut() == null) {
            return false;
        }
        if (other.getOptOut() != null && !other.getOptOut().equals(this.getOptOut())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        return other.getUser() == null || other.getUser().equals(this.getUser());
    }
}

