/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.targeting.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.NotificationClient;
import java.util.HashMap;

public class PinpointNotificationReceiver
extends BroadcastReceiver {
    private static volatile NotificationClient notificationClient = null;

    public static void setNotificationClient(NotificationClient notificationClient) {
        PinpointNotificationReceiver.notificationClient = notificationClient;
    }

    public void onReceive(Context context, Intent intent) {
        if (notificationClient != null) {
            String prefix = "pinpoint.campaign.";
            HashMap<String, String> campaignAttributes = new HashMap<String, String>();
            campaignAttributes.put("campaign_id", intent.getStringExtra("pinpoint.campaign.".concat("campaign_id")));
            campaignAttributes.put("treatment_id", intent.getStringExtra("pinpoint.campaign.".concat("treatment_id")));
            campaignAttributes.put("campaign_activity_id", intent.getStringExtra("pinpoint.campaign.".concat("campaign_activity_id")));
            notificationClient.handleNotificationOpen(campaignAttributes, intent.getExtras());
        } else {
            PackageManager pm = context.getPackageManager();
            Intent launchIntent = pm.getLaunchIntentForPackage(intent.getPackage());
            launchIntent.putExtras(intent.getExtras());
            context.startActivity(launchIntent);
        }
    }
}

