/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.targeting.notification;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidPreferences;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.AppLevelOptOutProvider;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.AppUtil;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.GCMTokenRegisteredHandler;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.PinpointNotificationReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationClient {
    public static final String INTENT_SNS_NOTIFICATION_FROM = "from";
    public static final String INTENT_SNS_NOTIFICATION_DATA = "data";
    protected static final String PINPOINT_PUSH_KEY_PREFIX = "pinpoint.";
    protected static final String CAMPAIGN_PUSH_KEY_PREFIX = "pinpoint.campaign.";
    protected static final String CAMPAIGN_ID_ATTRIBUTE_KEY = "campaign_id";
    protected static final String CAMPAIGN_ID_PUSH_KEY = "pinpoint.campaign.campaign_id";
    protected static final String CAMPAIGN_ACTIVITY_ID_ATTRIBUTE_KEY = "campaign_activity_id";
    protected static final String CAMPAIGN_ACTIVITY_ID_PUSH_KEY = "pinpoint.campaign.campaign_activity_id";
    protected static final String CAMPAIGN_TREATMENT_ID_ATTRIBUTE_KEY = "treatment_id";
    protected static final String CAMPAIGN_TREATMENT_ID_PUSH_KEY = "pinpoint.campaign.treatment_id";
    private static final Log log = LogFactory.getLog(NotificationClient.class);
    private static final String GCM_TOKEN_PREF_KEY = "AWSPINPOINT.GCMTOKEN";
    private static final String GCM_NOTIFICATION_PUSH_KEY_PREFIX = "pinpoint.notification.";
    private static final String NOTIFICATION_SILENT_PUSH_KEY = "pinpoint.notification.silentPush";
    private static final String NOTIFICATION_TITLE_PUSH_KEY = "pinpoint.notification.title";
    private static final String NOTIFICATION_BODY_PUSH_KEY = "pinpoint.notification.body";
    private static final String NOTIFICATION_COLOR_PUSH_KEY = "pinpoint.notification.color";
    private static final String NOTIFICATION_ICON_PUSH_KEY = "pinpoint.notification.icon";
    private static final String CAMPAIGN_IMAGE_PUSH_KEY = "pinpoint.notification.imageUrl";
    private static final String CAMPAIGN_IMAGE_ICON_PUSH_KEY = "pinpoint.notification.imageIconUrl";
    private static final String CAMPAIGN_IMAGE_SMALL_ICON_PUSH_KEY = "pinpoint.notification.imageSmallIconUrl";
    private static final String CAMPAIGN_URL_PUSH_KEY = "pinpoint.url";
    private static final String CAMPAIGN_DEEP_LINK_PUSH_KEY = "pinpoint.deeplink";
    private static final String CAMPAIGN_OPEN_APP_PUSH_KEY = "pinpoint.openApp";
    private static final String REQUEST_ID = "requestId";
    private static final int INVALID_RESOURCE = 0;
    private static final int ANDROID_JELLYBEAN = 16;
    private static final int ANDROID_KITKAT = 19;
    private static final int ANDROID_LOLLIPOP = 21;
    private static final int ANDROID_MARSHMALLOW = 23;
    private static final String AWS_EVENT_TYPE_OPENED = "_campaign.opened_notification";
    private static final String AWS_EVENT_TYPE_RECEIVED_FOREGROUND = "_campaign.received_foreground";
    private static final String AWS_EVENT_TYPE_RECEIVED_BACKGROUND = "_campaign.received_background";
    private static final String GCM_INTENT_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String FCM_INTENT_ACTION = "com.amazonaws.intent.fcm.NOTIFICATION_OPEN";
    private static final String CHECK_OP_NO_THROW = "checkOpNoThrow";
    private static final String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
    private static final String APP_OPS_MODE_ALLOWED = "MODE_ALLOWED";
    private static final String APP_OPS_SERVICE = "APP_OPS_SERVICE";
    private final PinpointContext pinpointContext;
    private final AppUtil appUtil;
    private final List<GCMTokenRegisteredHandler> gcmTokenRegisteredHandlers;
    private volatile String theGCMToken;
    private Constructor<?> notificationBuilderConstructor = null;
    private Class<?> notificationBuilderClass = null;
    private Class<?> notificationBigTextStyleClass = null;
    private Class<?> notificationBigPictureStyleClass = null;
    private Class<?> notificationStyleClass = null;
    private Class<?> iconClass = null;
    private Method setContentTitleMethod;
    private Method setContentTextMethod;
    private Method setSmallIconMethod;
    private Method setSmallIconResIdMethod;
    private Method setLargeIconMethod;
    private Method setContentIntent;
    private Method setStyleMethod;
    private Method buildMethod;
    private Method bigTextMethod;
    private Method bigPictureMethod;
    private Method setSummaryMethod;
    private Method setPriorityMethod;
    private Method setSoundMethod;
    private Method createWithBitmapMethod;
    private Bitmap notificationImage;
    private Class<?> appOpsClass = null;
    private Method checkOpNoThrowMethod = null;
    private Field opPostNotificationField = null;
    private Field modeAllowedField = null;
    private static final float RED_MULTIPLIER = 0.299f;
    private static final float GREEN_MULTIPLIER = 0.587f;
    private static final float BLUE_MULTIPLIER = 0.114f;
    private static final int TRANSPARENT_WHITE_COLOR = 0xFFFFFF;
    private static final int BITS_TO_SHIFT_FOR_ALPHA = 24;
    private static final int MAX_ALPHA = Color.alpha((int)-1);

    public NotificationClient(PinpointContext pinpointContext) {
        this.pinpointContext = pinpointContext;
        this.appUtil = new AppUtil(pinpointContext.getApplicationContext());
        this.gcmTokenRegisteredHandlers = new ArrayList<GCMTokenRegisteredHandler>();
        this.loadGCMToken();
    }

    public void addGCMTokenRegisteredHandler(GCMTokenRegisteredHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("GCMTokenRegisteredHandler cannot be null.");
        }
        this.gcmTokenRegisteredHandlers.add(handler);
    }

    public void removeGCMTokenRegisteredHandler(GCMTokenRegisteredHandler handler) {
        this.gcmTokenRegisteredHandlers.remove(handler);
    }

    public void registerGCMDeviceToken(String deviceToken) {
        this.theGCMToken = deviceToken;
        AndroidPreferences prefs = this.pinpointContext.getSystem().getPreferences();
        prefs.putString(GCM_TOKEN_PREF_KEY, deviceToken);
        for (GCMTokenRegisteredHandler handler : this.gcmTokenRegisteredHandlers) {
            handler.tokenRegistered(deviceToken);
        }
    }

    private void loadGCMToken() {
        AndroidPreferences prefs = this.pinpointContext.getSystem().getPreferences();
        this.theGCMToken = prefs.getString(GCM_TOKEN_PREF_KEY, null);
    }

    public String getGCMDeviceToken() {
        this.loadGCMToken();
        return this.theGCMToken;
    }

    private void addGlobalCampaignAttributes(Map<String, String> campaignAttribs) {
        for (Map.Entry<String, String> entry : campaignAttribs.entrySet()) {
            if (entry.getValue() == null) continue;
            this.pinpointContext.getAnalyticsClient().addGlobalAttribute(entry.getKey(), entry.getValue());
        }
    }

    void addCampaignAttributesToEvent(AnalyticsEvent pushEvent, Map<String, String> campaignAttribs) {
        for (Map.Entry<String, String> entry : campaignAttribs.entrySet()) {
            if (entry.getValue() == null) continue;
            pushEvent.addAttribute(entry.getKey(), entry.getValue());
        }
    }

    private Resources getPackageResources() {
        PackageManager packageManager = this.pinpointContext.getApplicationContext().getPackageManager();
        try {
            String packageName = this.pinpointContext.getApplicationContext().getPackageName();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 128);
            return packageManager.getResourcesForApplication(applicationInfo);
        }
        catch (PackageManager.NameNotFoundException ex) {
            log.error((Object)"Can't find resources for our application package.", (Throwable)ex);
            return null;
        }
    }

    private int getNotificationIconResourceId(String drawableResourceName) {
        PackageManager packageManager = this.pinpointContext.getApplicationContext().getPackageManager();
        try {
            int resId;
            String packageName = this.pinpointContext.getApplicationContext().getPackageName();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 128);
            Resources resources = packageManager.getResourcesForApplication(applicationInfo);
            if (drawableResourceName != null && (resId = resources.getIdentifier(drawableResourceName, "drawable", packageName)) != 0) {
                return resId;
            }
            return applicationInfo.icon;
        }
        catch (PackageManager.NameNotFoundException ex) {
            log.error((Object)"Can't find icon for our application package.", (Throwable)ex);
            return 0;
        }
    }

    private Notification createLegacyNotification(int iconResId, String title, String contentText, PendingIntent contentIntent) {
        Notification notification = new Notification();
        notification.icon = iconResId;
        notification.setLatestEventInfo(this.pinpointContext.getApplicationContext(), (CharSequence)title, (CharSequence)contentText, contentIntent);
        notification.contentIntent = contentIntent;
        return notification;
    }

    private boolean initClassesAndMethodsByReflection() {
        if (this.notificationBuilderClass != null) {
            return true;
        }
        try {
            this.notificationBuilderClass = Class.forName("android.app.Notification$Builder");
            this.notificationBigTextStyleClass = Class.forName("android.app.Notification$BigTextStyle");
            this.notificationStyleClass = Class.forName("android.app.Notification$Style");
            this.notificationBigPictureStyleClass = Class.forName("android.app.Notification$BigPictureStyle");
            if (Build.VERSION.SDK_INT >= 23) {
                this.iconClass = Class.forName("android.graphics.drawable.Icon");
            }
            return this.buildMethodsByReflection();
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)("Failed to get notification builder classes by reflection : " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    private boolean buildMethodsByReflection() {
        try {
            this.notificationBuilderConstructor = this.notificationBuilderClass.getDeclaredConstructor(Context.class);
            this.setContentTitleMethod = this.notificationBuilderClass.getDeclaredMethod("setContentTitle", CharSequence.class);
            this.setContentTextMethod = this.notificationBuilderClass.getDeclaredMethod("setContentText", CharSequence.class);
            this.setContentIntent = this.notificationBuilderClass.getDeclaredMethod("setContentIntent", PendingIntent.class);
            this.setStyleMethod = this.notificationBuilderClass.getDeclaredMethod("setStyle", this.notificationStyleClass);
            this.setSmallIconResIdMethod = this.notificationBuilderClass.getDeclaredMethod("setSmallIcon", Integer.TYPE);
            this.buildMethod = this.notificationBuilderClass.getDeclaredMethod("build", new Class[0]);
            this.bigTextMethod = this.notificationBigTextStyleClass.getDeclaredMethod("bigText", CharSequence.class);
            this.bigPictureMethod = this.notificationBigPictureStyleClass.getDeclaredMethod("bigPicture", Bitmap.class);
            this.setSummaryMethod = this.notificationBigPictureStyleClass.getDeclaredMethod("setSummaryText", CharSequence.class);
            this.setLargeIconMethod = this.notificationBuilderClass.getDeclaredMethod("setLargeIcon", Bitmap.class);
            this.setPriorityMethod = this.notificationBuilderClass.getDeclaredMethod("setPriority", Integer.TYPE);
            this.setSoundMethod = this.notificationBuilderClass.getDeclaredMethod("setSound", Uri.class);
            if (Build.VERSION.SDK_INT >= 23) {
                this.setSmallIconMethod = this.notificationBuilderClass.getDeclaredMethod("setSmallIcon", this.iconClass);
                this.createWithBitmapMethod = this.iconClass.getDeclaredMethod("createWithBitmap", Bitmap.class);
            }
            return true;
        }
        catch (NoSuchMethodException ex) {
            log.debug((Object)("Failed to get notification builder methods by reflection. : " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    static Bitmap convertBitmapToAlphaGreyscale(Bitmap input) {
        int pixelCount = input.getWidth() * input.getHeight();
        int[] inPixels = new int[pixelCount];
        input.getPixels(inPixels, 0, input.getWidth(), 0, 0, input.getWidth(), input.getHeight());
        int[] outPixels = new int[pixelCount];
        boolean hasMoreThanOneNonTransparentColor = false;
        Integer firstColor = null;
        for (int i = 0; i < pixelCount; ++i) {
            int inputArgb = inPixels[i];
            int inputAlpha = Color.alpha((int)inputArgb);
            int calculatedColor = MAX_ALPHA - (Math.round((float)Color.red((int)inputArgb) * 0.299f) + Math.round((float)Color.green((int)inputArgb) * 0.587f) + Math.round((float)Color.blue((int)inputArgb) * 0.114f));
            if (inputAlpha != 0) {
                if (firstColor == null) {
                    firstColor = inputArgb & 0xFFFFFF;
                } else if ((inputArgb & 0xFFFFFF) != firstColor) {
                    hasMoreThanOneNonTransparentColor = true;
                }
            }
            int greyScale = calculatedColor * inputAlpha / MAX_ALPHA;
            outPixels[i] = greyScale << 24 | 0xFFFFFF;
        }
        if (!hasMoreThanOneNonTransparentColor) {
            return Bitmap.createBitmap((int[])inPixels, (int)input.getWidth(), (int)input.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return Bitmap.createBitmap((int[])outPixels, (int)input.getWidth(), (int)input.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private void setSmallIconWithFallbackToLargeIconForSDKAbove20(Object notificationBuilder, boolean alreadySetLargeIcon, int iconResId, Bitmap largeIconBitmap) throws InvocationTargetException, IllegalAccessException {
        Bitmap iconBitmap;
        Resources resources;
        if (!alreadySetLargeIcon && Build.VERSION.SDK_INT >= 21 && (resources = this.getPackageResources()) != null && (iconBitmap = largeIconBitmap == null ? BitmapFactory.decodeResource((Resources)resources, (int)iconResId) : largeIconBitmap) != null) {
            this.setLargeIconMethod.invoke(notificationBuilder, iconBitmap);
            if (Build.VERSION.SDK_INT >= 23) {
                Bitmap smallBitmap = NotificationClient.convertBitmapToAlphaGreyscale(iconBitmap);
                this.setSmallIconMethod.invoke(notificationBuilder, this.createWithBitmapMethod.invoke(this.iconClass, smallBitmap));
            } else {
                this.setSmallIconResIdMethod.invoke(notificationBuilder, iconResId);
            }
            return;
        }
        this.setSmallIconResIdMethod.invoke(notificationBuilder, iconResId);
    }

    private boolean buildNotificationIcons(int iconResId, String imageIconUrl, String imageSmallIconUrl, Object notificationBuilder) {
        try {
            block15: {
                boolean setLargeIcon = false;
                Bitmap largeIconBitmap = null;
                if (imageIconUrl != null) {
                    try {
                        largeIconBitmap = (Bitmap)new DownloadImageTask().execute(new String[]{imageIconUrl}).get();
                        this.setLargeIconMethod.invoke(notificationBuilder, largeIconBitmap);
                        setLargeIcon = true;
                    }
                    catch (InterruptedException e) {
                        log.error((Object)("Interrupted when downloading image : " + e.getMessage()), (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        log.error((Object)("Failed execute download image thread : " + e.getMessage()), (Throwable)e);
                    }
                }
                if (imageSmallIconUrl != null && this.iconClass != null && Build.VERSION.SDK_INT >= 23) {
                    try {
                        Bitmap iconBitmap = (Bitmap)new DownloadImageTask().execute(new String[]{imageSmallIconUrl}).get();
                        if (!setLargeIcon && Build.VERSION.SDK_INT >= 21) {
                            this.setSmallIconWithFallbackToLargeIconForSDKAbove20(notificationBuilder, false, iconResId, iconBitmap);
                            break block15;
                        }
                        this.setSmallIconMethod.invoke(notificationBuilder, this.createWithBitmapMethod.invoke(this.iconClass, iconBitmap));
                    }
                    catch (InterruptedException e) {
                        log.error((Object)("Interrupted when downloading small icon : " + e.getMessage()), (Throwable)e);
                        this.setSmallIconWithFallbackToLargeIconForSDKAbove20(notificationBuilder, setLargeIcon, iconResId, null);
                    }
                    catch (ExecutionException e) {
                        log.error((Object)("Failed execute download image small icon thread : " + e.getMessage()), (Throwable)e);
                        this.setSmallIconWithFallbackToLargeIconForSDKAbove20(notificationBuilder, setLargeIcon, iconResId, null);
                    }
                } else if (setLargeIcon && Build.VERSION.SDK_INT >= 23) {
                    Bitmap smallBitmap = NotificationClient.convertBitmapToAlphaGreyscale(largeIconBitmap);
                    this.setSmallIconMethod.invoke(notificationBuilder, this.createWithBitmapMethod.invoke(this.iconClass, smallBitmap));
                } else {
                    this.setSmallIconWithFallbackToLargeIconForSDKAbove20(notificationBuilder, setLargeIcon, iconResId, null);
                }
            }
            return true;
        }
        catch (InvocationTargetException ex) {
            log.debug((Object)("Can't invoke notification builder methods. : " + ex.getMessage()), (Throwable)ex);
            return false;
        }
        catch (IllegalAccessException ex) {
            log.debug((Object)("Can't access notification builder methods. : " + ex.getMessage()), (Throwable)ex);
            return false;
        }
    }

    private Notification createNotification(int iconResId, String title, String contentText, String imageUrl, String imageIconUrl, String imageSmallIconUrl, PendingIntent contentIntent) {
        Object bigPictureStyle;
        Object bigTextStyle;
        Object notificationBuilder;
        log.info((Object)("Create Notification:" + title + ", Content:" + contentText));
        if (Build.VERSION.SDK_INT < 16) {
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
        if (!this.initClassesAndMethodsByReflection()) {
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
        try {
            notificationBuilder = this.notificationBuilderConstructor.newInstance(this.pinpointContext.getApplicationContext());
            bigTextStyle = this.notificationBigTextStyleClass.newInstance();
            bigPictureStyle = this.notificationBigPictureStyleClass.newInstance();
        }
        catch (InvocationTargetException ex) {
            log.debug((Object)("Can't invoke notification builder constructor. : " + ex.getMessage()), (Throwable)ex);
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
        catch (IllegalAccessException ex) {
            log.debug((Object)("Can't access notification builder or bigTextStyle or bigPictureStyle classes. : " + ex.getMessage()), (Throwable)ex);
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
        catch (InstantiationException ex) {
            log.debug((Object)("Exception while instantiating notification builder or bigTextStyle or bigPictureStyle classes. : " + ex.getMessage()), (Throwable)ex);
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
        try {
            this.setContentTitleMethod.invoke(notificationBuilder, title);
            this.setContentTextMethod.invoke(notificationBuilder, contentText);
            this.setContentIntent.invoke(notificationBuilder, contentIntent);
            this.setPriorityMethod.invoke(notificationBuilder, 1);
            Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
            this.setSoundMethod.invoke(notificationBuilder, defaultSoundUri);
            if (!this.buildNotificationIcons(iconResId, imageIconUrl, imageSmallIconUrl, notificationBuilder)) {
                return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
            }
            if (imageUrl != null) {
                try {
                    this.notificationImage = (Bitmap)new DownloadImageTask().execute(new String[]{imageUrl}).get();
                    if (this.notificationImage != null) {
                        this.bigPictureMethod.invoke(bigPictureStyle, this.notificationImage);
                        this.setSummaryMethod.invoke(bigPictureStyle, contentText);
                        this.setStyleMethod.invoke(notificationBuilder, bigPictureStyle);
                    } else {
                        this.bigTextMethod.invoke(bigTextStyle, contentText);
                        this.setStyleMethod.invoke(notificationBuilder, bigTextStyle);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)("Interrupted when downloading image : " + e.getMessage()), (Throwable)e);
                }
                catch (ExecutionException e) {
                    log.error((Object)("Failed execute download image thread : " + e.getMessage()), (Throwable)e);
                }
            }
            return (Notification)this.buildMethod.invoke(notificationBuilder, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            log.debug((Object)("Can't invoke notification builder methods. : " + ex.getMessage()), (Throwable)ex);
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
        catch (IllegalAccessException ex) {
            log.debug((Object)("Can't access notification builder methods. : " + ex.getMessage()), (Throwable)ex);
            return this.createLegacyNotification(iconResId, title, contentText, contentIntent);
        }
    }

    private PendingIntent createOpenAppPendingIntent(Bundle pushBundle, Class<?> targetClass, String campaignId, int requestId, String intentAction) {
        PendingIntent contentIntent = null;
        if (intentAction.equals(GCM_INTENT_ACTION)) {
            contentIntent = PendingIntent.getService((Context)this.pinpointContext.getApplicationContext(), (int)requestId, (Intent)this.notificationIntent(pushBundle, campaignId, requestId, GCM_INTENT_ACTION, targetClass), (int)0x40000000);
        } else {
            contentIntent = PendingIntent.getBroadcast((Context)this.pinpointContext.getApplicationContext(), (int)requestId, (Intent)this.notificationIntent(pushBundle, campaignId, requestId, FCM_INTENT_ACTION, targetClass), (int)0x40000000);
            PinpointNotificationReceiver.setNotificationClient(this);
        }
        return contentIntent;
    }

    private Intent notificationIntent(Bundle pushBundle, String campaignId, int requestId, String intentAction, Class<?> targetClass) {
        Intent notificationIntent = new Intent(this.pinpointContext.getApplicationContext(), targetClass);
        notificationIntent.setFlags(0x24000000);
        notificationIntent.setAction(intentAction);
        notificationIntent.putExtras(pushBundle);
        notificationIntent.putExtra(INTENT_SNS_NOTIFICATION_FROM, AWS_EVENT_TYPE_OPENED);
        notificationIntent.putExtra(CAMPAIGN_ID_PUSH_KEY, campaignId);
        notificationIntent.putExtra(REQUEST_ID, requestId);
        notificationIntent.setPackage(this.pinpointContext.getApplicationContext().getPackageName());
        return notificationIntent;
    }

    int getNotificationRequestId(String campaignId, String activityId) {
        return (campaignId + ":" + activityId).hashCode();
    }

    private boolean displayNotification(Bundle pushBundle, Class<?> targetClass, String imageUrl, String iconImageUrl, String iconSmallImageUrl, Map<String, String> campaignAttributes, String intentAction) {
        log.info((Object)("Display Notification: " + pushBundle.toString()));
        String title = pushBundle.getString(NOTIFICATION_TITLE_PUSH_KEY);
        String message = pushBundle.getString(NOTIFICATION_BODY_PUSH_KEY);
        String campaignId = campaignAttributes.get(CAMPAIGN_ID_ATTRIBUTE_KEY);
        String activityId = campaignAttributes.get(CAMPAIGN_ACTIVITY_ID_ATTRIBUTE_KEY);
        int requestID = this.getNotificationRequestId(campaignId, activityId);
        int iconResId = this.getNotificationIconResourceId(pushBundle.getString(NOTIFICATION_ICON_PUSH_KEY));
        if (iconResId == 0) {
            return false;
        }
        Notification notification = this.createNotification(iconResId, title, message, imageUrl, iconImageUrl, iconSmallImageUrl, this.createOpenAppPendingIntent(pushBundle, targetClass, campaignId, requestID, intentAction));
        notification.flags |= 0x10;
        notification.defaults |= 3;
        if (Build.VERSION.SDK_INT >= 21) {
            log.info((Object)("SDK greater than 21 detected: " + Build.VERSION.SDK_INT));
            String colorString = pushBundle.getString(NOTIFICATION_COLOR_PUSH_KEY);
            if (colorString != null) {
                int color;
                try {
                    color = Color.parseColor((String)colorString);
                }
                catch (IllegalArgumentException ex) {
                    log.warn((Object)"Couldn't parse campaign notification color.", (Throwable)ex);
                    color = 0;
                }
                ReflectiveOperationException exception = null;
                try {
                    Field colorField = notification.getClass().getDeclaredField("color");
                    colorField.setAccessible(true);
                    colorField.set(notification, color);
                }
                catch (IllegalAccessException ex) {
                    exception = ex;
                }
                catch (NoSuchFieldException ex) {
                    exception = ex;
                }
                if (exception != null) {
                    log.error((Object)("Couldn't set campaign notification color : " + exception.getMessage()), (Throwable)exception);
                }
            }
        }
        NotificationManager notificationManager = (NotificationManager)this.pinpointContext.getApplicationContext().getSystemService("notification");
        notificationManager.notify(requestID, notification);
        return true;
    }

    private boolean openApp() {
        Intent launchIntent = this.pinpointContext.getApplicationContext().getPackageManager().getLaunchIntentForPackage(this.pinpointContext.getApplicationContext().getPackageName());
        if (launchIntent == null) {
            log.error((Object)"Couldn't get app launch intent for campaign notification.");
            return false;
        }
        launchIntent.setFlags(0x10200000);
        launchIntent.setPackage(null);
        this.pinpointContext.getApplicationContext().startActivity(launchIntent);
        return true;
    }

    private void openURL(String url, boolean noSchemeValidation) {
        String validatedUrl = url.startsWith("http://") || url.startsWith("https://") || noSchemeValidation ? url : "http://" + url;
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)validatedUrl));
        intent.setFlags(0x10000000);
        if (intent.resolveActivity(this.pinpointContext.getApplicationContext().getPackageManager()) != null) {
            this.pinpointContext.getApplicationContext().startActivity(intent);
        }
    }

    public CampaignPushResult handleFCMCampaignPush(String from, Map<String, String> data) {
        log.info((Object)("Handling FCM Notification: " + data.toString()));
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return this.handleCampaignPush(from, bundle, PinpointNotificationReceiver.class, FCM_INTENT_ACTION);
    }

    public CampaignPushResult handleGCMCampaignPush(String from, Bundle data, Class<? extends Service> serviceClass) {
        log.info((Object)("Handling GCM Notification: " + data.toString()));
        return this.handleCampaignPush(from, data, serviceClass, GCM_INTENT_ACTION);
    }

    CampaignPushResult handleNotificationOpen(Map<String, String> campaignAttributes, Bundle data) {
        if (campaignAttributes != null) {
            if (this.pinpointContext.getSessionClient() != null) {
                this.pinpointContext.getSessionClient().stopSession();
            }
            this.addGlobalCampaignAttributes(campaignAttributes);
            AnalyticsEvent pushEvent = this.pinpointContext.getAnalyticsClient().createEvent(AWS_EVENT_TYPE_OPENED);
            this.pinpointContext.getAnalyticsClient().recordEvent(pushEvent);
            this.pinpointContext.getAnalyticsClient().submitEvents();
            String url = data.getString(CAMPAIGN_URL_PUSH_KEY);
            if (url != null) {
                this.openURL(url, false);
                return CampaignPushResult.NOTIFICATION_OPENED;
            }
            String deepLink = data.getString(CAMPAIGN_DEEP_LINK_PUSH_KEY);
            if (deepLink != null) {
                this.openURL(deepLink, true);
                return CampaignPushResult.NOTIFICATION_OPENED;
            }
            String openApp = data.getString(CAMPAIGN_OPEN_APP_PUSH_KEY);
            if (openApp == null) {
                log.warn((Object)"No key/value present to determine action for campaign notification, default to open app.");
            }
            this.openApp();
        }
        return CampaignPushResult.NOTIFICATION_OPENED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CampaignPushResult handleCampaignPush(String from, Bundle data, Class<?> targetClass, String intentAction) {
        if (!data.containsKey(CAMPAIGN_ID_PUSH_KEY)) {
            return CampaignPushResult.NOT_HANDLED;
        }
        boolean isAppInForeground = this.appUtil.isAppInForeground();
        String imageUrl = data.getString(CAMPAIGN_IMAGE_PUSH_KEY);
        String imageIconUrl = data.getString(CAMPAIGN_IMAGE_ICON_PUSH_KEY);
        String imageSmallIconUrl = data.getString(CAMPAIGN_IMAGE_SMALL_ICON_PUSH_KEY);
        HashMap<String, String> campaignAttributes = new HashMap<String, String>();
        campaignAttributes.put(CAMPAIGN_ID_ATTRIBUTE_KEY, data.getString(CAMPAIGN_ID_PUSH_KEY));
        campaignAttributes.put(CAMPAIGN_TREATMENT_ID_ATTRIBUTE_KEY, data.getString(CAMPAIGN_TREATMENT_ID_PUSH_KEY));
        campaignAttributes.put(CAMPAIGN_ACTIVITY_ID_ATTRIBUTE_KEY, data.getString(CAMPAIGN_ACTIVITY_ID_PUSH_KEY));
        this.pinpointContext.getAnalyticsClient().setCampaignAttributes(campaignAttributes);
        log.info((Object)("Campaign Attributes are:" + campaignAttributes));
        if (AWS_EVENT_TYPE_OPENED.equals(from)) {
            return this.handleNotificationOpen(campaignAttributes, data);
        }
        if (campaignAttributes != null) {
            String eventType = null;
            eventType = isAppInForeground ? AWS_EVENT_TYPE_RECEIVED_FOREGROUND : AWS_EVENT_TYPE_RECEIVED_BACKGROUND;
            AnalyticsEvent pushEvent = this.pinpointContext.getAnalyticsClient().createEvent(eventType);
            this.addCampaignAttributesToEvent(pushEvent, campaignAttributes);
            pushEvent.addAttribute("isAppInForeground", Boolean.toString(isAppInForeground));
            try {
                if (!this.pinpointContext.getPinpointConfiguration().getShouldPostNotificationsInForeground() && isAppInForeground) {
                    CampaignPushResult campaignPushResult = CampaignPushResult.APP_IN_FOREGROUND;
                    return campaignPushResult;
                }
                if ("1".equalsIgnoreCase(data.getString(NOTIFICATION_SILENT_PUSH_KEY))) {
                    CampaignPushResult campaignPushResult = CampaignPushResult.SILENT;
                    return campaignPushResult;
                }
                if (!this.areAppNotificationsEnabled() || !this.displayNotification(data, targetClass, imageUrl, imageIconUrl, imageSmallIconUrl, campaignAttributes, intentAction)) {
                    pushEvent.addAttribute("isOptedOut", "true");
                    CampaignPushResult campaignPushResult = CampaignPushResult.OPTED_OUT;
                    return campaignPushResult;
                }
            }
            finally {
                this.pinpointContext.getAnalyticsClient().recordEvent(pushEvent);
                this.pinpointContext.getAnalyticsClient().submitEvents();
            }
        }
        return CampaignPushResult.POSTED_NOTIFICATION;
    }

    public boolean areAppNotificationsEnabled() {
        AppLevelOptOutProvider provider = this.pinpointContext.getPinpointConfiguration().getAppLevelOptOutProvider();
        if (provider != null && provider.isOptedOut()) {
            return false;
        }
        return this.areAppNotificationsEnabledOnPlatform();
    }

    boolean areAppNotificationsEnabledOnPlatform() {
        String appOpsServiceName;
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        try {
            Field appOpsServiceNameField = Context.class.getDeclaredField(APP_OPS_SERVICE);
            appOpsServiceName = (String)appOpsServiceNameField.get(String.class);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        Object mAppOps = this.pinpointContext.getApplicationContext().getSystemService(appOpsServiceName);
        if (mAppOps == null) {
            return true;
        }
        ApplicationInfo appInfo = this.pinpointContext.getApplicationContext().getApplicationInfo();
        String pkg = this.pinpointContext.getApplicationContext().getPackageName();
        int uid = appInfo.uid;
        try {
            if (this.appOpsClass == null || this.checkOpNoThrowMethod == null || this.opPostNotificationField == null || this.modeAllowedField == null) {
                this.appOpsClass = Class.forName(mAppOps.getClass().getName());
                this.checkOpNoThrowMethod = this.appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
                this.opPostNotificationField = this.appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
                this.modeAllowedField = this.appOpsClass.getDeclaredField(APP_OPS_MODE_ALLOWED);
            }
            int postNotificationValue = this.opPostNotificationField.getInt(null);
            int opPostNotificationMode = (Integer)this.checkOpNoThrowMethod.invoke(mAppOps, postNotificationValue, uid, pkg);
            int modeAllowed = this.modeAllowedField.getInt(null);
            return modeAllowed == opPostNotificationMode;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private class DownloadImageTask
    extends AsyncTask<String, Void, Bitmap> {
        private DownloadImageTask() {
        }

        protected Bitmap doInBackground(String ... urls) {
            try {
                return BitmapFactory.decodeStream((InputStream)new URL(urls[0]).openConnection().getInputStream());
            }
            catch (IOException ex) {
                log.error((Object)"Cannot download or find image for rich notification.", (Throwable)ex);
                return null;
            }
        }
    }

    public static enum CampaignPushResult {
        NOT_HANDLED,
        POSTED_NOTIFICATION,
        APP_IN_FOREGROUND,
        OPTED_OUT,
        NOTIFICATION_OPENED,
        SILENT;

    }
}

