/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.targeting.endpointProfile;

import android.os.Build;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONSerializable;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONObject;

public class EndpointProfileDemographic
implements JSONSerializable {
    public static final String ENDPOINT_PLATFORM = "ANDROID";
    private String make = "";
    private String model = Build.MODEL;
    private String timezone = TimeZone.getDefault().getID();
    private Locale locale = Locale.getDefault();
    private String appVersion = "";
    private String platform = "ANDROID";
    private String platformVersion = Build.VERSION.RELEASE;

    public EndpointProfileDemographic(PinpointContext context) {
        Preconditions.checkNotNull(context, "A valid pinpointContext must be provided");
        this.make = context.getSystem().getDeviceDetails().manufacturer();
        this.appVersion = context.getSystem().getAppDetails().versionName();
    }

    public String getMake() {
        return this.make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONBuilder builder = new JSONBuilder(null);
        builder.withAttribute("Make", this.getMake());
        builder.withAttribute("Model", this.getModel());
        builder.withAttribute("Timezone", this.getTimezone());
        builder.withAttribute("Locale", this.getLocale());
        builder.withAttribute("AppVersion", this.getAppVersion());
        builder.withAttribute("Platform", this.getPlatform());
        builder.withAttribute("PlatformVersion", this.getPlatformVersion());
        return builder.toJSONObject();
    }
}

