/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.targeting.endpointProfile;

import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.DateUtil;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONSerializable;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.pinpoint.targeting.endpointProfile.EndpointProfileDemographic;
import com.amazonaws.mobileconnectors.pinpoint.targeting.endpointProfile.EndpointProfileLocation;
import com.amazonaws.mobileconnectors.pinpoint.targeting.endpointProfile.EndpointProfileUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EndpointProfile
implements JSONSerializable {
    static final int MAX_NUM_OF_METRICS_AND_ATTRIBUTES = 20;
    static final int MAX_ENDPOINT_ATTRIBUTE_METRIC_KEY_LENGTH = 50;
    static final int MAX_ENDPOINT_ATTRIBUTE_VALUE_LENGTH = 100;
    static final int MAX_ENDPOINT_ATTRIBUTE_VALUES = 50;
    private static final Log log = LogFactory.getLog(EndpointProfile.class);
    private static final int JSON_INDENTATION = 4;
    private final PinpointContext pinpointContext;
    private final Map<String, List<String>> attributes = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, Double> metrics = new ConcurrentHashMap<String, Double>();
    private final AtomicInteger currentNumOfAttributesAndMetrics = new AtomicInteger(0);
    private String optOut;
    private EndpointProfileLocation location;
    private EndpointProfileDemographic demographic;
    private Long effectiveDate;
    private EndpointProfileUser user;

    public EndpointProfile(PinpointContext pinpointContext) {
        Preconditions.checkNotNull(pinpointContext, "A valid pinpointContext must be provided.");
        this.pinpointContext = pinpointContext;
        this.effectiveDate = DateUtil.getCorrectedDate().getTime();
        this.demographic = new EndpointProfileDemographic(this.pinpointContext);
        this.location = new EndpointProfileLocation();
        this.user = new EndpointProfileUser();
    }

    private static String processAttributeMetricKey(String key) {
        String trimmedKey = StringUtil.clipString(key, 50, false);
        if (trimmedKey.length() < key.length()) {
            log.warn((Object)"The attribute key has been trimmed to a length of 50 characters.");
        }
        return trimmedKey;
    }

    private static List<String> processAttributeValues(List<String> values) {
        ArrayList<String> trimmedValues = new ArrayList<String>();
        int valuesCount = 0;
        for (String value : values) {
            String trimmedValue = StringUtil.clipString(value, 100, false);
            if (trimmedValue.length() < value.length()) {
                log.warn((Object)"The attribute value has been trimmed to a length of 100 characters.");
            }
            trimmedValues.add(trimmedValue);
            if (++valuesCount < 50) continue;
            log.warn((Object)"The attribute values has been reduced to50 values.");
            break;
        }
        return trimmedValues;
    }

    public String getApplicationId() {
        return this.pinpointContext.getSystem().getAppDetails().getAppId();
    }

    public String getEndpointId() {
        return this.pinpointContext.getUniqueId();
    }

    public String getChannelType() {
        return "GCM";
    }

    public String getAddress() {
        return this.pinpointContext.getNotificationClient().getGCMDeviceToken();
    }

    public EndpointProfileDemographic getDemographic() {
        return this.demographic;
    }

    public void setDemographic(EndpointProfileDemographic demographic) {
        this.demographic = demographic;
    }

    public EndpointProfileLocation getLocation() {
        return this.location;
    }

    public void setLocation(EndpointProfileLocation location) {
        this.location = location;
    }

    public long getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(long effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getOptOut() {
        return this.pinpointContext.getNotificationClient().areAppNotificationsEnabled() && !StringUtil.isBlank(this.pinpointContext.getNotificationClient().getGCMDeviceToken()) ? "NONE" : "ALL";
    }

    public void addAttribute(String name, List<String> values) {
        if (null == name) {
            return;
        }
        if (null != values) {
            if (this.currentNumOfAttributesAndMetrics.get() < 20) {
                String key = EndpointProfile.processAttributeMetricKey(name);
                if (!this.attributes.containsKey(key)) {
                    this.currentNumOfAttributesAndMetrics.incrementAndGet();
                }
                this.attributes.put(key, EndpointProfile.processAttributeValues(values));
            } else {
                log.warn((Object)"Max number of attributes/metrics reached(20).");
            }
        } else if (this.attributes.remove(name) != null) {
            this.currentNumOfAttributesAndMetrics.decrementAndGet();
        }
    }

    public boolean hasAttribute(String attributeName) {
        if (attributeName == null) {
            return false;
        }
        return this.attributes.containsKey(attributeName);
    }

    public List<String> getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public EndpointProfile withAttribute(String name, List<String> values) {
        this.addAttribute(name, values);
        return this;
    }

    public Map<String, List<String>> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void addMetric(String name, Double value) {
        if (null == name) {
            return;
        }
        if (null != value) {
            if (this.currentNumOfAttributesAndMetrics.get() < 20) {
                String key = EndpointProfile.processAttributeMetricKey(name);
                if (!this.metrics.containsKey(key)) {
                    this.currentNumOfAttributesAndMetrics.incrementAndGet();
                }
                this.metrics.put(key, value);
            } else {
                log.warn((Object)"Max number of attributes/metrics reached(20).");
            }
        } else if (this.metrics.remove(name) != null) {
            this.currentNumOfAttributesAndMetrics.decrementAndGet();
        }
    }

    public boolean hasMetric(String metricName) {
        if (metricName == null) {
            return false;
        }
        return this.metrics.containsKey(metricName);
    }

    public Double getMetric(String name) {
        if (name == null) {
            return null;
        }
        return this.metrics.get(name);
    }

    public EndpointProfile withMetric(String name, Double value) {
        this.addMetric(name, value);
        return this;
    }

    public Map<String, Double> getAllMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public EndpointProfileUser getUser() {
        return this.user;
    }

    public void setUser(EndpointProfileUser user) {
        this.user = user;
    }

    public String toString() {
        JSONObject json = this.toJSONObject();
        try {
            return json.toString(4);
        }
        catch (JSONException e) {
            return json.toString();
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONBuilder builder = new JSONBuilder(null);
        builder.withAttribute("ApplicationId", this.getApplicationId());
        builder.withAttribute("EndpointId", this.getEndpointId());
        builder.withAttribute("ChannelType", this.getChannelType());
        builder.withAttribute("Address", this.getAddress());
        builder.withAttribute("Location", this.getLocation().toJSONObject());
        builder.withAttribute("Demographic", this.getDemographic().toJSONObject());
        builder.withAttribute("EffectiveDate", DateUtil.isoDateFromMillis(this.getEffectiveDate()));
        builder.withAttribute("OptOut", this.getOptOut());
        JSONObject attributesJson = new JSONObject();
        for (Map.Entry<String, List<String>> entry : this.getAllAttributes().entrySet()) {
            try {
                JSONArray array = new JSONArray((Collection)entry.getValue());
                attributesJson.put(entry.getKey(), (Object)array);
            }
            catch (JSONException e) {
                log.warn((Object)"Error serializing attributes.");
            }
        }
        if (attributesJson.length() > 0) {
            builder.withAttribute("Attributes", attributesJson);
        }
        JSONObject metricsJson = new JSONObject();
        for (Map.Entry<String, Double> entry : this.getAllMetrics().entrySet()) {
            try {
                metricsJson.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                log.error((Object)"Error serializing metric.");
            }
        }
        if (metricsJson.length() > 0) {
            builder.withAttribute("Metrics", metricsJson);
        }
        builder.withAttribute("User", this.getUser().toJSONObject());
        return builder.toJSONObject();
    }
}

