/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.targeting;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.mobileconnectors.pinpoint.PinpointManager;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.pinpoint.targeting.endpointProfile.EndpointProfile;
import com.amazonaws.services.pinpoint.model.EndpointDemographic;
import com.amazonaws.services.pinpoint.model.EndpointLocation;
import com.amazonaws.services.pinpoint.model.EndpointRequest;
import com.amazonaws.services.pinpoint.model.EndpointUser;
import com.amazonaws.services.pinpoint.model.UpdateEndpointRequest;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TargetingClient {
    private static final String USER_AGENT = PinpointManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final Log log = LogFactory.getLog(TargetingClient.class);
    private static final int MAX_EVENT_OPERATIONS = 1000;
    private static final String CUSTOM_ATTRIBUTES_KEY = "ENDPOINT_PROFILE_CUSTOM_ATTRIBUTES";
    private static final String CUSTOM_METRICS_KEY = "ENDPOINT_PROFILE_CUSTOM_METRICS";
    private final PinpointContext context;
    private final Map<String, List<String>> globalAttributes;
    private final Map<String, Double> globalMetrics;
    private final ExecutorService endpointRunnableQueue;
    private final EndpointProfile endpointProfile;

    public TargetingClient(PinpointContext context, ThreadPoolExecutor executor) {
        Preconditions.checkNotNull(context, "A valid pinpointContext must be provided");
        this.endpointRunnableQueue = executor;
        this.context = context;
        this.endpointProfile = new EndpointProfile(this.context);
        this.globalAttributes = this.loadAttributes();
        this.globalMetrics = this.loadMetrics();
    }

    public TargetingClient(PinpointContext context) {
        this(context, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.DiscardPolicy()));
    }

    public EndpointProfile currentEndpoint() {
        if (!this.globalAttributes.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : this.globalAttributes.entrySet()) {
                this.endpointProfile.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (!this.globalMetrics.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.globalMetrics.entrySet()) {
                this.endpointProfile.addMetric(entry.getKey(), (Double)entry.getValue());
            }
        }
        return this.endpointProfile;
    }

    public void updateEndpointProfile() {
        this.executeUpdate(this.currentEndpoint());
    }

    public void updateEndpointProfile(EndpointProfile endpointProfile) {
        if (!this.globalAttributes.isEmpty()) {
            for (Map.Entry<String, List<String>> entry : this.globalAttributes.entrySet()) {
                endpointProfile.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (!this.globalMetrics.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.globalMetrics.entrySet()) {
                endpointProfile.addMetric(entry.getKey(), (Double)entry.getValue());
            }
        }
        this.executeUpdate(endpointProfile);
    }

    private void executeUpdate(EndpointProfile endpointProfile) {
        String locale;
        if (endpointProfile == null) {
            log.error((Object)"EndpointProfile is null, failed to update profile.");
            return;
        }
        try {
            locale = endpointProfile.getDemographic().getLocale().getISO3Country();
        }
        catch (MissingResourceException exception) {
            log.debug((Object)"Locale getISO3Country failed, falling back to getCountry.");
            locale = endpointProfile.getDemographic().getLocale().getCountry();
        }
        EndpointDemographic demographic = new EndpointDemographic().withAppVersion(endpointProfile.getDemographic().getAppVersion()).withLocale(locale).withTimezone(endpointProfile.getDemographic().getTimezone()).withMake(endpointProfile.getDemographic().getMake()).withModel(endpointProfile.getDemographic().getModel()).withPlatform(endpointProfile.getDemographic().getPlatform()).withPlatformVersion(endpointProfile.getDemographic().getPlatformVersion());
        EndpointLocation location = new EndpointLocation().withLatitude(endpointProfile.getLocation().getLatitude()).withLongitude(endpointProfile.getLocation().getLongitude()).withPostalCode(endpointProfile.getLocation().getPostalCode()).withCity(endpointProfile.getLocation().getCity()).withRegion(endpointProfile.getLocation().getRegion()).withCountry(endpointProfile.getLocation().getCountry());
        EndpointUser user = new EndpointUser();
        user.setUserId(endpointProfile.getUser().getUserId());
        EndpointRequest endpointRequest = new EndpointRequest().withChannelType(endpointProfile.getChannelType()).withAddress(endpointProfile.getAddress()).withLocation(location).withDemographic(demographic).withEffectiveDate(DateUtils.formatISO8601Date((Date)new Date(endpointProfile.getEffectiveDate()))).withOptOut(endpointProfile.getOptOut()).withAttributes(endpointProfile.getAllAttributes()).withMetrics(endpointProfile.getAllMetrics()).withUser(user);
        final UpdateEndpointRequest updateEndpointRequest = new UpdateEndpointRequest().withApplicationId(endpointProfile.getApplicationId()).withEndpointId(endpointProfile.getEndpointId()).withEndpointRequest(endpointRequest);
        updateEndpointRequest.getRequestClientOptions().appendUserAgent(USER_AGENT);
        this.endpointRunnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info((Object)"Updating EndpointProfile.");
                    TargetingClient.this.context.getPinpointServiceClient().updateEndpoint(updateEndpointRequest);
                    log.info((Object)"EndpointProfile updated successfully.");
                }
                catch (AmazonServiceException e) {
                    log.error((Object)"AmazonServiceException occurred during endpoint update:", (Throwable)e);
                }
                catch (AmazonClientException e) {
                    log.info((Object)"AmazonClientException occurred during endpoint update:", (Throwable)e);
                }
            }
        });
    }

    private void saveAttributes() {
        JSONObject jsonObject = new JSONObject(this.globalAttributes);
        String jsonString = jsonObject.toString();
        this.context.getSystem().getPreferences().putString(CUSTOM_ATTRIBUTES_KEY, jsonString);
    }

    private Map<String, List<String>> loadAttributes() {
        ConcurrentHashMap<String, List<String>> outputMap = new ConcurrentHashMap<String, List<String>>();
        String jsonString = this.context.getSystem().getPreferences().getString(CUSTOM_ATTRIBUTES_KEY, null);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return outputMap;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                JSONArray jsonArray = jsonObject.getJSONArray(key);
                ArrayList<String> listValues = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    listValues.add(jsonArray.getString(i));
                }
                outputMap.put(key, listValues);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return outputMap;
    }

    private void saveMetrics() {
        JSONObject jsonObject = new JSONObject(this.globalMetrics);
        String jsonString = jsonObject.toString();
        this.context.getSystem().getPreferences().putString(CUSTOM_METRICS_KEY, jsonString);
    }

    private Map<String, Double> loadMetrics() {
        ConcurrentHashMap<String, Double> outputMap = new ConcurrentHashMap<String, Double>();
        String jsonString = this.context.getSystem().getPreferences().getString(CUSTOM_METRICS_KEY, null);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return outputMap;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator keysItr = jsonObject.keys();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                Double value = jsonObject.getDouble(key);
                outputMap.put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return outputMap;
    }

    public void addAttribute(String attributeName, List<String> attributeValues) {
        if (attributeName == null) {
            log.debug((Object)"Null attribute name provided to addGlobalAttribute.");
            return;
        }
        if (attributeValues == null) {
            log.debug((Object)"Null attribute values provided to addGlobalAttribute.");
            return;
        }
        this.globalAttributes.put(attributeName, attributeValues);
        this.saveAttributes();
    }

    public void removeAttribute(String attributeName) {
        if (attributeName == null) {
            log.warn((Object)"Null attribute name provided to removeGlobalAttribute.");
            return;
        }
        this.endpointProfile.addAttribute(attributeName, null);
        this.globalAttributes.remove(attributeName);
        this.saveAttributes();
    }

    public void addMetric(String metricName, Double metricValue) {
        if (metricName == null) {
            log.warn((Object)"Null metric name provided to addGlobalMetric.");
            return;
        }
        if (metricValue == null) {
            log.warn((Object)"Null metric value provided to addGlobalMetric.");
            return;
        }
        this.globalMetrics.put(metricName, metricValue);
        this.saveMetrics();
    }

    public void removeMetric(String metricName) {
        if (metricName == null) {
            log.warn((Object)"Null metric name provided to removeGlobalMetric.");
            return;
        }
        this.endpointProfile.addMetric(metricName, null);
        this.globalMetrics.remove(metricName);
        this.saveMetrics();
    }
}

