/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.event;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.PinpointDBBase;

public class PinpointDBUtil {
    private PinpointDBBase pinpointDBBase;

    public PinpointDBUtil(Context context) {
        if (this.pinpointDBBase == null) {
            this.pinpointDBBase = new PinpointDBBase(context);
        }
    }

    public void closeDB() {
        if (this.pinpointDBBase != null) {
            this.pinpointDBBase.closeDBHelper();
        }
    }

    public Uri saveEvent(AnalyticsEvent event) {
        return this.pinpointDBBase.insert(this.pinpointDBBase.getContentUri(), this.generateContentValuesFromEvent(event));
    }

    private ContentValues generateContentValuesFromEvent(AnalyticsEvent event) {
        ContentValues values = new ContentValues();
        String json = event.toJSONObject().toString();
        values.put("event_json", json);
        values.put("event_size", Integer.valueOf(json.length()));
        return values;
    }

    public Cursor queryAllEvents() {
        return this.pinpointDBBase.query(this.pinpointDBBase.getContentUri(), null, null, null, null, null);
    }

    public Cursor queryOldestEvents(int limit) {
        return this.pinpointDBBase.query(this.pinpointDBBase.getContentUri(), new String[]{"event_id", "event_size"}, null, null, null, Integer.toString(limit));
    }

    public Cursor queryEventById(int id) {
        return this.pinpointDBBase.query(this.getEventUri(id), null, null, null, null, null);
    }

    public int deleteEvent(int id, Integer size) {
        return this.pinpointDBBase.delete(this.getEventUri(id), null, null, size);
    }

    public Uri getContentUri() {
        return this.pinpointDBBase.getContentUri();
    }

    public Uri getEventUri(int id) {
        return Uri.parse((String)(this.pinpointDBBase.getContentUri() + "/" + id));
    }

    public long getTotalSize() {
        return this.pinpointDBBase.getTotalSize();
    }
}

