/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.event;

import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.PinpointDatabaseHelper;

public class PinpointDBBase {
    private static final int EVENTS = 10;
    private static final int EVENT_ID = 20;
    private static final String BASE_PATH = "events";
    private final Context context;
    private final Uri contentUri;
    private final UriMatcher uriMatcher;
    private final PinpointDatabaseHelper databaseHelper;
    private long totalSize = -1L;

    public PinpointDBBase(Context context) {
        this.context = context;
        String mAuthority = context.getApplicationContext().getPackageName();
        this.databaseHelper = new PinpointDatabaseHelper(this.context);
        this.contentUri = Uri.parse((String)("content://" + mAuthority + "/" + BASE_PATH));
        this.uriMatcher = new UriMatcher(-1);
        this.uriMatcher.addURI(mAuthority, BASE_PATH, 10);
        this.uriMatcher.addURI(mAuthority, "events/#", 20);
    }

    public void closeDBHelper() {
        this.databaseHelper.close();
    }

    public Uri getContentUri() {
        return this.contentUri;
    }

    public Uri insert(Uri uri, ContentValues values) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        long id = 0L;
        switch (uriType) {
            case 10: {
                long size = this.getTotalSize();
                id = db.insertOrThrow("pinpointevent", null, values);
                this.totalSize = size + values.getAsLong("event_size");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        return Uri.parse((String)("events/" + id));
    }

    public long getTotalSize() {
        Cursor cursor = null;
        try {
            if (this.totalSize < 0L) {
                cursor = this.databaseHelper.getReadableDatabase().rawQuery("SELECT SUM(event_size) FROM pinpointevent", null);
                this.totalSize = !cursor.moveToNext() ? 0L : (cursor.isNull(0) ? 0L : cursor.getLong(0));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return this.totalSize;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, String limit) {
        SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
        queryBuilder.setTables("pinpointevent");
        int uriType = this.uriMatcher.match(uri);
        switch (uriType) {
            case 10: {
                break;
            }
            case 20: {
                queryBuilder.appendWhere((CharSequence)("event_id=" + uri.getLastPathSegment()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = queryBuilder.query(db, projection, selection, selectionArgs, null, null, sortOrder, limit);
        return cursor;
    }

    public synchronized int update(Uri uri, ContentValues values, String whereClause, String[] whereArgs) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int rowsUpdated = 0;
        switch (uriType) {
            case 10: {
                rowsUpdated = db.update("pinpointevent", values, whereClause, whereArgs);
                break;
            }
            case 20: {
                String id = uri.getLastPathSegment();
                if (TextUtils.isEmpty((CharSequence)whereClause)) {
                    rowsUpdated = db.update("pinpointevent", values, "event_id=" + id, null);
                    break;
                }
                rowsUpdated = db.update("pinpointevent", values, "event_id=" + id + " and " + whereClause, whereArgs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        return rowsUpdated;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs, Integer knownSize) {
        int uriType = this.uriMatcher.match(uri);
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int rowsDeleted = 0;
        switch (uriType) {
            case 10: {
                rowsDeleted = db.delete("pinpointevent", selection, selectionArgs);
                this.totalSize = -1L;
                break;
            }
            case 20: {
                String id = uri.getLastPathSegment();
                long size = this.getTotalSize();
                rowsDeleted = TextUtils.isEmpty((CharSequence)selection) ? db.delete("pinpointevent", "event_id=" + id, null) : db.delete("pinpointevent", "event_id=" + id + " and " + selection, selectionArgs);
                if (rowsDeleted == 1) {
                    if (knownSize != null) {
                        this.totalSize = size - (long)knownSize.intValue();
                        break;
                    }
                    this.totalSize = -1L;
                    break;
                }
                this.totalSize = -1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URI: " + uri);
            }
        }
        return rowsDeleted;
    }
}

