/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.event;

import android.database.Cursor;
import android.net.Uri;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.mobileconnectors.pinpoint.PinpointManager;
import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.ClientContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.EventTable;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.PinpointDBUtil;
import com.amazonaws.mobileconnectors.pinpoint.targeting.TargetingClient;
import com.amazonaws.services.pinpointanalytics.model.Event;
import com.amazonaws.services.pinpointanalytics.model.PutEventsRequest;
import com.amazonaws.services.pinpointanalytics.model.Session;
import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.VersionInfoUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventRecorder {
    static final String KEY_MAX_SUBMISSION_SIZE = "maxSubmissionSize";
    static final long DEFAULT_MAX_SUBMISSION_SIZE = 102400L;
    static final String KEY_MAX_PENDING_SIZE = "maxPendingSize";
    static final long DEFAULT_MAX_PENDING_SIZE = 0x500000L;
    static final String KEY_MAX_SUBMISSIONS_ALLOWED = "maxSubmissionAllowed";
    static final int DEFAULT_MAX_SUBMISSIONS_ALLOWED = 3;
    private static final String USER_AGENT = PinpointManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final int CLIPPED_EVENT_LENGTH = 10;
    private static final int MAX_EVENT_OPERATIONS = 1000;
    private static final long MINIMUM_PENDING_SIZE = 16384L;
    private static final Log log = LogFactory.getLog(EventRecorder.class);
    private final PinpointDBUtil dbUtil;
    private final ExecutorService submissionRunnableQueue;
    private final PinpointContext pinpointContext;

    EventRecorder(PinpointContext pinpointContext, PinpointDBUtil dbUtil, ExecutorService submissionRunnableQueue) {
        this.pinpointContext = pinpointContext;
        this.dbUtil = dbUtil;
        this.submissionRunnableQueue = submissionRunnableQueue;
    }

    public static EventRecorder newInstance(PinpointContext pinpointContext) {
        return EventRecorder.newInstance(pinpointContext, new PinpointDBUtil(pinpointContext.getApplicationContext().getApplicationContext()));
    }

    public static EventRecorder newInstance(PinpointContext pinpointContext, PinpointDBUtil dbUtil) {
        ThreadPoolExecutor submissionRunnableQueue = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.DiscardPolicy());
        return new EventRecorder(pinpointContext, dbUtil, submissionRunnableQueue);
    }

    public void closeDB() {
        this.dbUtil.closeDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri recordEvent(AnalyticsEvent event) {
        Uri uri;
        long maxPendingSize;
        if (event != null) {
            log.info((Object)String.format("Event Recorded to database with EventType: %s", StringUtil.clipString(event.getEventType(), 10, true)));
        }
        if ((maxPendingSize = this.pinpointContext.getConfiguration().optLong(KEY_MAX_PENDING_SIZE, 0x500000L).longValue()) < 16384L) {
            maxPendingSize = 16384L;
        }
        if ((uri = this.dbUtil.saveEvent(event)) != null) {
            while (this.dbUtil.getTotalSize() > maxPendingSize) {
                Cursor cursor = null;
                try {
                    cursor = this.dbUtil.queryOldestEvents(5);
                    while (this.dbUtil.getTotalSize() > maxPendingSize && cursor.moveToNext()) {
                        this.dbUtil.deleteEvent(cursor.getInt(EventTable.COLUMN_INDEX.ID.getValue()), cursor.getInt(EventTable.COLUMN_INDEX.SIZE.getValue()));
                    }
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            return uri;
        }
        log.warn((Object)String.format("Event: '%s' failed to record to local database.", StringUtil.clipString(event.getEventType(), 10, true)));
        return null;
    }

    JSONObject translateFromCursor(Cursor cursor) {
        try {
            return new JSONObject(cursor.getString(EventTable.COLUMN_INDEX.JSON.getValue()));
        }
        catch (JSONException e) {
            log.error((Object)String.format("Unable to format events.", new Object[0]));
            return null;
        }
    }

    public void submitEvents() {
        this.submissionRunnableQueue.execute(new Runnable(){

            @Override
            public void run() {
                EventRecorder.this.processEvents();
            }
        });
    }

    JSONArray getBatchOfEvents(Cursor cursor, List<Integer> idsToDeletes, List<Integer> sizeToDeletes) {
        long eventLength;
        JSONArray eventArray = new JSONArray();
        long currentRequestSize = 0L;
        long maxRequestSize = this.pinpointContext.getConfiguration().optLong(KEY_MAX_SUBMISSION_SIZE, 102400L);
        JSONObject json = this.translateFromCursor(cursor);
        idsToDeletes.add(cursor.getInt(EventTable.COLUMN_INDEX.ID.getValue()));
        sizeToDeletes.add(cursor.getInt(EventTable.COLUMN_INDEX.ID.getValue()));
        if (json != null) {
            eventLength = json.length();
            currentRequestSize += eventLength;
            eventArray.put((Object)json);
        }
        while (cursor.moveToNext()) {
            json = this.translateFromCursor(cursor);
            idsToDeletes.add(cursor.getInt(EventTable.COLUMN_INDEX.ID.getValue()));
            sizeToDeletes.add(cursor.getInt(EventTable.COLUMN_INDEX.ID.getValue()));
            if (json == null) continue;
            eventLength = json.length();
            eventArray.put((Object)json);
            if ((currentRequestSize += eventLength) <= maxRequestSize) continue;
            break;
        }
        return eventArray;
    }

    public List<JSONObject> getAllEvents() {
        ArrayList<JSONObject> events = new ArrayList<JSONObject>();
        Cursor cursor = null;
        try {
            cursor = this.dbUtil.queryAllEvents();
            while (cursor.moveToNext()) {
                events.add(this.translateFromCursor(cursor));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEvents() {
        long start = System.currentTimeMillis();
        Cursor cursor = null;
        try {
            cursor = this.dbUtil.queryAllEvents();
            ArrayList<Integer> idsToDeletes = new ArrayList<Integer>();
            ArrayList<Integer> sizeToDeletes = new ArrayList<Integer>();
            int submissions = 0;
            long maxSubmissionsAllowed = this.pinpointContext.getConfiguration().optInt(KEY_MAX_SUBMISSIONS_ALLOWED, 3).intValue();
            while (cursor.moveToNext()) {
                ArrayList<Integer> batchIdsToDeletes = new ArrayList<Integer>();
                ArrayList<Integer> batchSizeToDeletes = new ArrayList<Integer>();
                boolean successful = this.submitEvents(this.getBatchOfEvents(cursor, batchIdsToDeletes, batchSizeToDeletes));
                if (successful) {
                    idsToDeletes.addAll(batchIdsToDeletes);
                    sizeToDeletes.addAll(batchSizeToDeletes);
                    ++submissions;
                }
                if ((long)submissions < maxSubmissionsAllowed) continue;
                break;
            }
            if (sizeToDeletes.size() > 0) {
                for (int i = 0; i < sizeToDeletes.size(); ++i) {
                    try {
                        this.dbUtil.deleteEvent((Integer)idsToDeletes.get(i), (Integer)sizeToDeletes.get(i));
                        continue;
                    }
                    catch (Exception exc) {
                        log.error((Object)("Failed to delete event: " + idsToDeletes.get(i)), (Throwable)exc);
                    }
                }
            }
            log.info((Object)String.format("Time of attemptDelivery: %d", System.currentTimeMillis() - start));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    boolean submitEvents(JSONArray eventArray) {
        boolean submitted = false;
        PutEventsRequest request = this.createRecordEventsRequest(eventArray, this.pinpointContext.getNetworkType(), this.pinpointContext.getTargetingClient());
        request.withClientContextEncoding("base64");
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        try {
            this.pinpointContext.getAnalyticsServiceClient().putEvents(request);
            submitted = true;
            log.info((Object)String.format("Successful submission of %d events.", eventArray.length()));
            return submitted;
        }
        catch (AmazonServiceException e) {
            log.error((Object)"AmazonServiceException occured during send of put event ", (Throwable)e);
            String errorCode = e.getErrorCode();
            if (errorCode.equalsIgnoreCase("ValidationException") || errorCode.equalsIgnoreCase("SerializationException") || errorCode.equalsIgnoreCase("BadRequestException")) {
                submitted = true;
                log.error((Object)String.format("Failed to submit events to EventService: statusCode: " + e.getStatusCode() + " errorCode: ", errorCode));
                log.error((Object)String.format("Failed submission of %d events, events will be removed", eventArray.length()), (Throwable)e);
                return submitted;
            }
            log.warn((Object)("Unable to successfully deliver events to server. Events will be saved, error likely recoverable.  Response status code " + e.getStatusCode() + " , response error code " + e.getErrorCode() + e.getMessage()));
            log.warn((Object)("Received an error response: " + e.getMessage()));
        }
        catch (Exception e2) {
            log.warn((Object)("Unable to successfully deliver events to server. Events will be saved, error likely recoverable." + e2.getMessage()));
        }
        return submitted;
    }

    public PutEventsRequest createRecordEventsRequest(JSONArray events, String networkType, TargetingClient targetingClient) {
        if (events == null || events.length() == 0) {
            return null;
        }
        PutEventsRequest putRequest = new PutEventsRequest();
        ArrayList<Event> eventList = new ArrayList<Event>();
        ClientContext clientContext = null;
        for (int i = 0; i < events.length(); ++i) {
            JSONObject eventJSON = null;
            AnalyticsEvent internalEvent = null;
            try {
                eventJSON = events.getJSONObject(i);
                internalEvent = AnalyticsEvent.translateToEvent(eventJSON);
            }
            catch (JSONException e) {
                log.error((Object)"Stored event was invalid JSON.");
                continue;
            }
            clientContext = internalEvent.createClientContext(networkType);
            if (targetingClient != null && targetingClient.currentEndpoint() != null) {
                String endpoint = targetingClient.currentEndpoint().toJSONObject().toString();
                HashMap<String, String> customAttribute = new HashMap<String, String>();
                customAttribute.put("endpoint", endpoint);
                clientContext.setCustom(customAttribute);
                log.info((Object)"Recorded profile to client pinpointContext.");
            } else {
                log.error((Object)"Event Client is null.");
            }
            Event event = new Event();
            Session session = new Session();
            session.withId(internalEvent.getSession().getSessionId());
            session.withStartTimestamp(DateUtils.formatISO8601Date((Date)new Date(internalEvent.getSession().getSessionStart())));
            if (internalEvent.getSession().getSessionStop() != null && internalEvent.getSession().getSessionStop() != 0L) {
                session.withStopTimestamp(DateUtils.formatISO8601Date((Date)new Date(internalEvent.getSession().getSessionStop())));
            }
            if (internalEvent.getSession().getSessionDuration() != null && internalEvent.getSession().getSessionDuration() != 0L) {
                session.withDuration(internalEvent.getSession().getSessionDuration());
            }
            event.withAttributes(internalEvent.getAllAttributes()).withMetrics(internalEvent.getAllMetrics()).withEventType(internalEvent.getEventType()).withTimestamp(DateUtils.formatISO8601Date((Date)new Date(internalEvent.getEventTimestamp()))).withSession(session);
            eventList.add(event);
        }
        if (clientContext != null && eventList.size() > 0) {
            putRequest.withEvents(eventList).withClientContext(Base64.encodeAsString((byte[])clientContext.toJSONObject().toString().getBytes()));
        } else {
            log.error((Object)"ClientContext is null or event list is empty.");
        }
        return putRequest;
    }
}

