/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Set;

public final class StringUtil {
    public static final String UTF_8 = "UTF-8";

    private StringUtil() {
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String convertStreamToString(InputStream is, Charset charset) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, charset));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    public static String convertStreamToUTF8String(InputStream is) throws IOException {
        return StringUtil.convertStreamToString(is, Charset.forName(UTF_8));
    }

    public static String clipString(String input, int numChars, boolean appendEllipses) {
        int end = Math.min(numChars, input.length());
        String output = input.substring(0, end);
        if (appendEllipses) {
            output = output.length() < input.length() ? output + "..." : output;
        }
        return output;
    }

    public static String convertArrayToString(String[] stringArr) {
        if (stringArr == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < stringArr.length; ++i) {
            if (i > 0) {
                ret.append(",");
            }
            ret.append("'" + stringArr[i] + "'");
        }
        return ret.toString();
    }

    public static String convertSetToString(Set<String> stringSet) {
        if (stringSet == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (String str : stringSet) {
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append("'" + str + "'");
        }
        return ret.toString();
    }

    public static String trimOrPadString(String str, int len, char pad) {
        if (len < 0) {
            len = 0;
        }
        if (str == null) {
            str = "";
        }
        StringBuffer s = new StringBuffer();
        if (str.length() > len - 1) {
            s.append(str.substring(str.length() - len));
        } else {
            for (int i = 0; i < len - str.length(); ++i) {
                s.append(pad);
            }
            s.append(str);
        }
        return s.toString();
    }
}

