/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core.util;

import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONSerializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBuilder
implements JSONSerializable {
    private static final Log LOGGER = LogFactory.getLog(JSONBuilder.class);
    private static final int INDENTATION = 4;
    private final JSONObject json = new JSONObject();

    public JSONBuilder(Object component) {
        if (null != component) {
            this.withAttribute("class", component.getClass().getName());
            this.withAttribute("hashCode", Integer.toHexString(component.hashCode()));
        }
    }

    public JSONBuilder withAttribute(String key, Object value) {
        Object jsonValue = value instanceof JSONSerializable ? ((JSONSerializable)value).toJSONObject() : value;
        try {
            this.json.putOpt(key, jsonValue);
        }
        catch (JSONException e) {
            LOGGER.warn((Object)"error parsing json", (Throwable)e);
        }
        return this;
    }

    @Override
    public JSONObject toJSONObject() {
        return this.json;
    }

    public String toString() {
        try {
            if (this.json != null) {
                return this.json.toString(4);
            }
            return "";
        }
        catch (JSONException e) {
            return this.json.toString();
        }
    }
}

