/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core.system;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidAppDetails;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidConnectivity;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidDeviceDetails;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidPreferences;

public class AndroidSystem {
    private static final String PREFERENCES_AND_FILE_MANAGER_SUFFIX = "515d6767-01b7-49e5-8273-c8d11b0f331d";
    private final AndroidPreferences preferences;
    private final AndroidConnectivity connectivity;
    private final AndroidAppDetails appDetails;
    private final AndroidDeviceDetails deviceDetails;

    public AndroidSystem() {
        this.preferences = null;
        this.connectivity = null;
        this.appDetails = null;
        this.deviceDetails = null;
    }

    public AndroidSystem(Context context, String appId) {
        this.preferences = new AndroidPreferences(context, appId + PREFERENCES_AND_FILE_MANAGER_SUFFIX);
        this.connectivity = new AndroidConnectivity(context);
        this.appDetails = new AndroidAppDetails(context, appId);
        this.deviceDetails = new AndroidDeviceDetails(this.getCarrier(context));
    }

    private String getCarrier(Context context) {
        try {
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            if (null != telephony.getNetworkOperatorName() && !telephony.getNetworkOperatorName().equals("")) {
                return telephony.getNetworkOperatorName();
            }
            return "Unknown";
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    public AndroidPreferences getPreferences() {
        return this.preferences;
    }

    public AndroidConnectivity getConnectivity() {
        return this.connectivity;
    }

    public AndroidAppDetails getAppDetails() {
        return this.appDetails;
    }

    public AndroidDeviceDetails getDeviceDetails() {
        return this.deviceDetails;
    }
}

