/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core.system;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AndroidConnectivity {
    private static final Log log = LogFactory.getLog(AndroidConnectivity.class);
    protected boolean hasWifi;
    protected boolean hasMobile;
    protected boolean inAirplaneMode;
    private Context context;

    public AndroidConnectivity() {
    }

    public AndroidConnectivity(Context context) {
        this.context = context;
    }

    public boolean isConnected() {
        this.determineAvailability();
        return this.hasWifi() || this.hasWAN();
    }

    public boolean hasWifi() {
        return this.hasWifi;
    }

    public boolean hasWAN() {
        return this.hasMobile && !this.inAirplaneMode;
    }

    private void determineAvailability() {
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        this.inAirplaneMode = Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
        log.info((Object)("Airplane mode: " + this.inAirplaneMode));
        NetworkInfo networkInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        int networkType = 0;
        this.hasWifi = false;
        boolean bl = this.hasMobile = cm != null;
        if (networkInfo != null) {
            if (networkInfo.isConnectedOrConnecting()) {
                networkType = networkInfo.getType();
                this.hasWifi = networkType == 1 || networkType == 6;
                this.hasMobile = networkType == 0 || networkType == 4 || networkType == 5 || networkType == 2 || networkType == 3;
            } else {
                this.hasMobile = false;
            }
        }
        log.info((Object)String.format("Device Connectivity (%s)", this.hasWifi ? "On Wifi" : (this.hasMobile ? "On Mobile" : "No network connectivity")));
    }
}

