/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core.idresolver;

import android.content.Context;
import android.content.SharedPreferences;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidPreferences;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedPrefsUniqueIdService {
    protected static final String UNIQUE_ID_KEY = "UniqueId";
    private static final Log log = LogFactory.getLog(SharedPrefsUniqueIdService.class);
    private String appId = null;
    private Context applicationContext = null;

    public SharedPrefsUniqueIdService(String appId, Context applicationContext) {
        this.appId = appId;
        this.applicationContext = applicationContext;
    }

    public String getUniqueId(PinpointContext context) {
        if (context == null || context.getSystem() == null || context.getSystem().getPreferences() == null) {
            log.debug((Object)"Unable to generate unique id, pinpointContext has not been fully initialized.");
            return "";
        }
        String uniqueId = this.getIdFromPreferences(context.getSystem().getPreferences());
        if (uniqueId == null || uniqueId == "") {
            uniqueId = UUID.randomUUID().toString();
            this.storeUniqueId(context.getSystem().getPreferences(), uniqueId);
        }
        return uniqueId;
    }

    private String getIdFromPreferences(AndroidPreferences preferences) {
        if (this.getLegacyId() != "") {
            return this.getLegacyId();
        }
        return preferences.getString(UNIQUE_ID_KEY, null);
    }

    private String getLegacyId() {
        if (this.appId == null || this.applicationContext == null) {
            return "";
        }
        SharedPreferences legacyPreferences = this.applicationContext.getSharedPreferences(this.appId, 0);
        String legacyId = legacyPreferences.getString(UNIQUE_ID_KEY, null);
        if (legacyId != null) {
            return legacyId;
        }
        return "";
    }

    private void storeUniqueId(AndroidPreferences preferences, String uniqueId) {
        try {
            preferences.putString(UNIQUE_ID_KEY, uniqueId);
        }
        catch (Exception ex) {
            log.error((Object)"There was an exception when trying to store the unique id into the Preferences.");
        }
    }
}

