/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core.configuration;

import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidPreferences;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidPreferencesConfiguration {
    private static final Log log = LogFactory.getLog(AndroidPreferencesConfiguration.class);
    private static final String CONFIG_KEY = "configuration";
    private final PinpointContext context;
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    AndroidPreferencesConfiguration(PinpointContext context) {
        String configurationJsonString;
        Preconditions.checkNotNull(context);
        this.context = context;
        JSONObject configJson = null;
        AndroidPreferences preferences = this.getContext().getSystem().getPreferences();
        if (preferences != null && (configurationJsonString = preferences.getString(CONFIG_KEY, null)) != null) {
            try {
                configJson = new JSONObject(configurationJsonString);
            }
            catch (JSONException e) {
                log.error((Object)"Could not create Json object of Config.");
            }
        }
        this.updateMappings(configJson);
    }

    public static AndroidPreferencesConfiguration newInstance(PinpointContext context) {
        return new AndroidPreferencesConfiguration(context);
    }

    public Long getLong(String propertyName) {
        Long value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Long.decode(valueString);
            }
            catch (Exception ex) {
                log.error((Object)"Could not get Long for property.");
            }
        }
        return value;
    }

    public String getString(String propertyName) {
        String value = this.properties.get(propertyName);
        return value;
    }

    public Integer getInt(String propertyName) {
        Integer value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Integer.decode(valueString);
            }
            catch (Exception ex) {
                log.error((Object)"Could not get Integer for property.");
            }
        }
        return value;
    }

    public Double getDouble(String propertyName) {
        Double value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Double.parseDouble(valueString);
            }
            catch (Exception ex) {
                log.error((Object)"Could not get Double for property.");
            }
        }
        return value;
    }

    public Boolean getBoolean(String propertyName) {
        Boolean value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Boolean.parseBoolean(valueString);
            }
            catch (Exception ex) {
                log.error((Object)"Could not get Boolean for property.");
            }
        }
        return value;
    }

    public Short getShort(String propertyName) {
        Short value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                if (this.properties.containsKey(propertyName)) {
                    value = Short.decode(valueString);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Could not get Short for property.");
            }
        }
        return value;
    }

    public Long optLong(String propertyName, Long optValue) {
        Long value = this.getLong(propertyName);
        return value != null ? value : optValue;
    }

    public String optString(String propertyName, String optValue) {
        String value = this.getString(propertyName);
        return value != null ? value : optValue;
    }

    public Integer optInt(String propertyName, Integer optValue) {
        Integer value = this.getInt(propertyName);
        return value != null ? value : optValue;
    }

    public Short optShort(String propertyName, Short optValue) {
        Short value = this.getShort(propertyName);
        return value != null ? value : optValue;
    }

    public Double optDouble(String propertyName, Double optValue) {
        Double value = this.getDouble(propertyName);
        return value != null ? value : optValue;
    }

    public Boolean optBoolean(String propertyName, Boolean optValue) {
        Boolean value = this.getBoolean(propertyName);
        return value != null ? value : optValue;
    }

    private void updateMappings(JSONObject configJson) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        if (configJson != null) {
            Iterator keys = configJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    String value = configJson.getString(key);
                    newProperties.put(key, value);
                }
                catch (JSONException e) {
                    log.error((Object)"Could not update property mappings.");
                }
            }
        }
        this.properties.putAll(newProperties);
    }

    private PinpointContext getContext() {
        return this.context;
    }
}

