/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.internal.core;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amazonaws.mobileconnectors.pinpoint.PinpointConfiguration;
import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.SessionClient;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.configuration.AndroidPreferencesConfiguration;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.http.SDKInfoHandler;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.idresolver.SharedPrefsUniqueIdService;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidSystem;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.SDKInfo;
import com.amazonaws.mobileconnectors.pinpoint.targeting.TargetingClient;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.NotificationClient;
import com.amazonaws.services.pinpoint.AmazonPinpoint;
import com.amazonaws.services.pinpoint.AmazonPinpointClient;
import com.amazonaws.services.pinpointanalytics.AmazonPinpointAnalyticsClient;
import java.io.Serializable;

public class PinpointContext
implements Serializable {
    private final AndroidPreferencesConfiguration configuration;
    private final PinpointConfiguration pinpointConfiguration;
    private final SDKInfo sdkInfo;
    private final SharedPrefsUniqueIdService uniqueIdService;
    private final AndroidSystem system;
    private final AmazonPinpointAnalyticsClient analyticsServiceClient;
    private final AmazonPinpointClient pinpointServiceClient;
    private final Context applicationContext;
    private String uniqueId;
    private AnalyticsClient analyticsClient;
    private TargetingClient targetingClient;
    private SessionClient sessionClient;
    private NotificationClient notificationClient;

    public PinpointContext() {
        this.configuration = null;
        this.pinpointConfiguration = null;
        this.sdkInfo = null;
        this.uniqueIdService = null;
        this.system = null;
        this.analyticsServiceClient = null;
        this.pinpointServiceClient = null;
        this.applicationContext = null;
        this.analyticsClient = null;
        this.targetingClient = null;
        this.sessionClient = null;
        this.notificationClient = null;
    }

    public PinpointContext(AmazonPinpointAnalyticsClient analyticsServiceClient, AmazonPinpointClient pinpointServiceClient, Context applicationContext, String appId, SDKInfo sdkInfo, PinpointConfiguration pinpointConfiguration) {
        this.sdkInfo = sdkInfo;
        this.pinpointConfiguration = pinpointConfiguration;
        this.system = new AndroidSystem(applicationContext, appId);
        this.uniqueIdService = new SharedPrefsUniqueIdService(appId, applicationContext);
        this.uniqueId = this.uniqueIdService.getUniqueId(this);
        this.analyticsServiceClient = analyticsServiceClient;
        this.pinpointServiceClient = pinpointServiceClient;
        this.applicationContext = applicationContext;
        this.configuration = AndroidPreferencesConfiguration.newInstance(this);
        analyticsServiceClient.addRequestHandler(new SDKInfoHandler(sdkInfo));
        pinpointServiceClient.addRequestHandler(new SDKInfoHandler(sdkInfo));
    }

    public NotificationClient getNotificationClient() {
        return this.notificationClient;
    }

    public void setNotificationClient(NotificationClient notificationClient) {
        this.notificationClient = notificationClient;
    }

    public AnalyticsClient getAnalyticsClient() {
        return this.analyticsClient;
    }

    public void setAnalyticsClient(AnalyticsClient analyticsClient) {
        this.analyticsClient = analyticsClient;
    }

    public SessionClient getSessionClient() {
        return this.sessionClient;
    }

    public void setSessionClient(SessionClient sessionClient) {
        this.sessionClient = sessionClient;
    }

    public TargetingClient getTargetingClient() {
        return this.targetingClient;
    }

    public void setTargetingClient(TargetingClient targetingClient) {
        this.targetingClient = targetingClient;
    }

    public AndroidPreferencesConfiguration getConfiguration() {
        return this.configuration;
    }

    public PinpointConfiguration getPinpointConfiguration() {
        return this.pinpointConfiguration;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public SDKInfo getSDKInfo() {
        return this.sdkInfo;
    }

    public AndroidSystem getSystem() {
        return this.system;
    }

    public AmazonPinpointAnalyticsClient getAnalyticsServiceClient() {
        return this.analyticsServiceClient;
    }

    public AmazonPinpoint getPinpointServiceClient() {
        return this.pinpointServiceClient;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public String getNetworkType() {
        try {
            ConnectivityManager connectivity = (ConnectivityManager)this.applicationContext.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();
            if (null != networkInfo && networkInfo.isConnected() && networkInfo.isAvailable() && networkInfo.getTypeName() != null) {
                return networkInfo.getTypeName();
            }
            return "Unknown";
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }
}

