/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics.monetization;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.monetization.MonetizationEventBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static final Log log = LogFactory.getLog(VirtualMonetizationEventBuilder.class);

    protected VirtualMonetizationEventBuilder(AnalyticsClient analyticsClient) {
        super(analyticsClient);
        this.setStore("Virtual");
    }

    public static VirtualMonetizationEventBuilder create(AnalyticsClient analyticsClient) {
        return new VirtualMonetizationEventBuilder(analyticsClient);
    }

    public VirtualMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public VirtualMonetizationEventBuilder withItemPrice(double itemPrice) {
        this.setItemPrice(itemPrice);
        return this;
    }

    public VirtualMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public VirtualMonetizationEventBuilder withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    @Override
    protected boolean isValid() {
        if (this.getProductId() == null) {
            log.warn((Object)"Virtual Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            log.warn((Object)"Virtual Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getItemPrice() == null) {
            log.warn((Object)"Virtual Monetization event is not valid: it is missing the numerical price");
            return false;
        }
        if (this.getCurrency() == null) {
            log.warn((Object)"Virtual Monetization event is not valid: it is missing the currency");
            return false;
        }
        return true;
    }
}

