/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics.monetization;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MonetizationEventBuilder {
    static final String PURCHASE_EVENT_NAME = "_monetization.purchase";
    static final String PURCHASE_EVENT_QUANTITY_METRIC = "_quantity";
    static final String PURCHASE_EVENT_ITEM_PRICE_METRIC = "_item_price";
    static final String PURCHASE_EVENT_PRODUCT_ID_ATTR = "_product_id";
    static final String PURCHASE_EVENT_PRICE_FORMATTED_ATTR = "_item_price_formatted";
    static final String PURCHASE_EVENT_STORE_ATTR = "_store";
    static final String PURCHASE_EVENT_LOCALE_ATTR = "_locale";
    static final String PURCHASE_EVENT_TRANSACTION_ID_ATTR = "_transaction_id";
    static final String PURCHASE_EVENT_CURRENCY_ATTR = "_currency";
    static final String AMAZON_STORE = "Amazon";
    static final String GOOGLE_PLAY_STORE = "Google Play";
    static final String VIRTUAL_STORE = "Virtual";
    private static final Log log = LogFactory.getLog(MonetizationEventBuilder.class);
    private final AnalyticsClient analyticsClient;
    private String productId;
    private String store;
    private Double quantity;
    private String formattedItemPrice;
    private Double itemPrice;
    private String transactionId;
    private String currency;

    protected MonetizationEventBuilder(AnalyticsClient analyticsClient) {
        this.analyticsClient = analyticsClient;
    }

    public AnalyticsEvent build() {
        AnalyticsEvent purchaseEvent = null;
        if (this.isValid() && this.doBaseValidation()) {
            purchaseEvent = this.analyticsClient.createEvent(PURCHASE_EVENT_NAME);
            purchaseEvent.addAttribute(PURCHASE_EVENT_PRODUCT_ID_ATTR, this.productId);
            purchaseEvent.addAttribute(PURCHASE_EVENT_STORE_ATTR, this.store);
            purchaseEvent.addMetric(PURCHASE_EVENT_QUANTITY_METRIC, this.quantity);
            if (this.formattedItemPrice != null) {
                purchaseEvent.addAttribute(PURCHASE_EVENT_PRICE_FORMATTED_ATTR, this.formattedItemPrice);
            }
            if (this.itemPrice != null) {
                purchaseEvent.addMetric(PURCHASE_EVENT_ITEM_PRICE_METRIC, this.itemPrice);
            }
            if (this.transactionId != null) {
                purchaseEvent.addAttribute(PURCHASE_EVENT_TRANSACTION_ID_ATTR, this.transactionId);
            }
            if (this.currency != null) {
                purchaseEvent.addAttribute(PURCHASE_EVENT_CURRENCY_ATTR, this.currency);
            }
        }
        return purchaseEvent;
    }

    protected abstract boolean isValid();

    protected String getProductId() {
        return this.productId;
    }

    protected void setProductId(String productId) {
        this.productId = productId;
    }

    protected Double getQuantity() {
        return this.quantity;
    }

    protected void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    protected Double getItemPrice() {
        return this.itemPrice;
    }

    protected void setItemPrice(Double itemPrice) {
        this.itemPrice = itemPrice;
    }

    @Deprecated
    protected String getFormattedItemPrice() {
        return this.formattedItemPrice;
    }

    @Deprecated
    protected void setFormattedItemPrice(String formattedItemPrice) {
        this.formattedItemPrice = formattedItemPrice;
    }

    protected String getCurrency() {
        return this.currency;
    }

    protected void setCurrency(String currency) {
        this.currency = currency;
    }

    protected String getStore() {
        return this.store;
    }

    protected void setStore(String store) {
        this.store = store;
    }

    protected String getTransactionId() {
        return this.transactionId;
    }

    protected void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    private boolean doBaseValidation() {
        if (this.analyticsClient == null) {
            log.warn((Object)"Cannot build Monetization event: the analyticsClient is null");
            return false;
        }
        if (StringUtil.isNullOrEmpty(this.productId)) {
            log.warn((Object)"Base Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.quantity == null) {
            log.warn((Object)"Base Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (StringUtil.isNullOrEmpty(this.store)) {
            log.warn((Object)"Base Monetization event is not valid: it is missing the store");
            return false;
        }
        if ((StringUtil.isNullOrEmpty(this.currency) || this.itemPrice == null) && StringUtil.isNullOrEmpty(this.formattedItemPrice)) {
            log.warn((Object)"Base Monetization event is not valid: it requires the currency and price");
            return false;
        }
        return true;
    }
}

