/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics.monetization;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.monetization.MonetizationEventBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GooglePlayMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static final Log log = LogFactory.getLog(GooglePlayMonetizationEventBuilder.class);

    protected GooglePlayMonetizationEventBuilder(AnalyticsClient analyticsClient) {
        super(analyticsClient);
        this.setStore("Google Play");
    }

    public static GooglePlayMonetizationEventBuilder create(AnalyticsClient analyticsClient) {
        return new GooglePlayMonetizationEventBuilder(analyticsClient);
    }

    public GooglePlayMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    @Deprecated
    public GooglePlayMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withItemPrice(Double itemPrice) {
        this.setItemPrice(itemPrice);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    public GooglePlayMonetizationEventBuilder withTransactionId(String transactionId) {
        this.setTransactionId(transactionId);
        return this;
    }

    @Override
    protected boolean isValid() {
        if (this.getProductId() == null) {
            log.warn((Object)"Cannot build Google Monetization event: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            log.warn((Object)"Google Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getFormattedItemPrice() == null) {
            if (this.getCurrency() == null) {
                log.warn((Object)"Google Monetization event is not valid: it is missing the localized currency");
                return false;
            }
            if (this.getItemPrice() == null) {
                log.warn((Object)"Google Monetization event is not valid: it is missing the localized item price");
                return false;
            }
        }
        if (this.getTransactionId() == null) {
            log.warn((Object)"Google Monetization event is not valid: it is missing the transaction id");
            return false;
        }
        return true;
    }
}

