/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics.monetization;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.monetization.MonetizationEventBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static final Log log = LogFactory.getLog(CustomMonetizationEventBuilder.class);

    protected CustomMonetizationEventBuilder(AnalyticsClient analyticsClient) {
        super(analyticsClient);
    }

    public static CustomMonetizationEventBuilder create(AnalyticsClient analyticsClient) {
        return new CustomMonetizationEventBuilder(analyticsClient);
    }

    public CustomMonetizationEventBuilder withStore(String store) {
        this.setStore(store);
        return this;
    }

    public CustomMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    public CustomMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    @Deprecated
    public CustomMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public CustomMonetizationEventBuilder withItemPrice(double itemPrice) {
        this.setItemPrice(itemPrice);
        return this;
    }

    public CustomMonetizationEventBuilder withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    public CustomMonetizationEventBuilder withTransactionId(String transactionId) {
        this.setTransactionId(transactionId);
        return this;
    }

    @Override
    protected boolean isValid() {
        if (this.getStore() == null) {
            log.warn((Object)"Custom Monetization event is not valid: it is missing the store");
            return false;
        }
        if (this.getProductId() == null) {
            log.warn((Object)"Custom Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            log.warn((Object)"Custom Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getCurrency() == null || this.getItemPrice() == null) {
            log.warn((Object)"Custom Monetization event is not valid: it requires the formatted localized price or the currency and price");
            return false;
        }
        return true;
    }
}

