/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics.monetization;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.monetization.MonetizationEventBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonMonetizationEventBuilder
extends MonetizationEventBuilder {
    private static final Log log = LogFactory.getLog(AmazonMonetizationEventBuilder.class);

    protected AmazonMonetizationEventBuilder(AnalyticsClient analyticsClient) {
        super(analyticsClient);
        this.setStore("Amazon");
    }

    public static AmazonMonetizationEventBuilder create(AnalyticsClient analyticsClient) {
        return new AmazonMonetizationEventBuilder(analyticsClient);
    }

    public AmazonMonetizationEventBuilder withProductId(String productId) {
        this.setProductId(productId);
        return this;
    }

    @Deprecated
    public AmazonMonetizationEventBuilder withFormattedItemPrice(String formattedItemPrice) {
        this.setFormattedItemPrice(formattedItemPrice);
        return this;
    }

    public AmazonMonetizationEventBuilder withQuantity(Double quantity) {
        this.setQuantity(quantity);
        return this;
    }

    public AmazonMonetizationEventBuilder withItemPrice(Double itemPrice) {
        this.setItemPrice(itemPrice);
        return this;
    }

    public AmazonMonetizationEventBuilder withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    @Override
    protected boolean isValid() {
        if (this.getProductId() == null) {
            log.warn((Object)"Amazon Monetization event is not valid: it is missing the product id");
            return false;
        }
        if (this.getQuantity() == null) {
            log.warn((Object)"Amazon Monetization event is not valid: it is missing the quantity");
            return false;
        }
        if (this.getFormattedItemPrice() == null) {
            if (this.getCurrency() == null) {
                log.warn((Object)"Amazon Monetization event is not valid: it is missing the localized currency");
                return false;
            }
            if (this.getItemPrice() == null) {
                log.warn((Object)"Amazon Monetization event is not valid: it is missing the localized item price");
                return false;
            }
        }
        return true;
    }
}

