/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.pinpoint.analytics.Session;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionClient {
    public static final String SESSION_START_EVENT_TYPE = "_session.start";
    public static final String SESSION_STOP_EVENT_TYPE = "_session.stop";
    public static final String SESSION_PAUSE_EVENT_TYPE = "_session.pause";
    public static final String SESSION_RESUME_EVENT_TYPE = "_session.resume";
    protected static final long DEFAULT_RESUME_DELAY = 5000L;
    protected static final long DEFAULT_RESTART_DELAY = 30000L;
    protected static final String RESUME_DELAY_CONFIG_KEY = "sessionResumeDelay";
    protected static final String RESTART_DELAY_CONFIG_KEY = "sessionRestartDelay";
    protected static final String NO_SESSION_ID = "00000000-00000000";
    protected static final String SHARED_PREFS_SESSION_KEY = "AWSPinpoint.Session";
    private static final Log log = LogFactory.getLog(SessionClient.class);
    protected final PinpointContext pinpointContext;
    private final long resumeDelay;
    private final long restartDelay;
    protected Session session;

    public SessionClient(PinpointContext pinpointContext) {
        Preconditions.checkNotNull(pinpointContext, "A valid PinpointContext must be provided!");
        Preconditions.checkNotNull(pinpointContext.getAnalyticsClient(), "A valid AnalyticsClient must be provided!");
        this.pinpointContext = pinpointContext;
        String sessionString = pinpointContext.getSystem().getPreferences().getString(SHARED_PREFS_SESSION_KEY, null);
        if (sessionString != null) {
            this.session = Session.getSessionFromSerializedSession(sessionString);
        }
        if (this.session != null) {
            pinpointContext.getAnalyticsClient().setSessionId(this.session.getSessionID());
            pinpointContext.getAnalyticsClient().setSessionStartTime(this.session.getStartTime());
        } else if (pinpointContext.getPinpointConfiguration().getEnableTargeting()) {
            pinpointContext.getAnalyticsClient().setSessionId(NO_SESSION_ID);
            pinpointContext.getAnalyticsClient().setSessionStartTime(0L);
        }
        this.restartDelay = pinpointContext.getConfiguration().optLong(RESTART_DELAY_CONFIG_KEY, 30000L);
        this.resumeDelay = pinpointContext.getConfiguration().optLong(RESUME_DELAY_CONFIG_KEY, 5000L);
    }

    public synchronized void startSession() {
        this.executeStop();
        this.executeStart();
    }

    public synchronized void stopSession() {
        this.executeStop();
    }

    public synchronized void pauseSession() {
        if (this.getSessionState().equals((Object)SessionState.ACTIVE)) {
            this.executePause();
        }
    }

    public synchronized void resumeSession() {
        if (this.getSessionState().equals((Object)SessionState.PAUSED)) {
            this.executeResume();
        } else {
            AnalyticsEvent e = this.pinpointContext.getAnalyticsClient().createEvent(SESSION_RESUME_EVENT_TYPE);
            this.pinpointContext.getAnalyticsClient().recordEvent(e);
            log.info((Object)"Session Resume Failed: No session is paused.");
        }
    }

    public String toString() {
        return "[SessionClient]\n- session: " + (this.session == null ? "<null>" : this.session.getSessionID()) + (this.session != null && this.session.isPaused() ? ": paused" : "");
    }

    protected void executeStart() {
        if (this.pinpointContext.getTargetingClient() != null) {
            this.pinpointContext.getTargetingClient().updateEndpointProfile();
        }
        this.session = Session.newInstance(this.pinpointContext);
        this.pinpointContext.getAnalyticsClient().setSessionId(this.session.getSessionID());
        this.pinpointContext.getAnalyticsClient().setSessionStartTime(this.session.getStartTime());
        log.info((Object)"Firing Session Event: _session.start");
        AnalyticsEvent e = this.pinpointContext.getAnalyticsClient().createEvent(SESSION_START_EVENT_TYPE);
        this.pinpointContext.getAnalyticsClient().recordEvent(e);
    }

    protected void executeStop() {
        if (this.session == null) {
            log.info((Object)"Session Stop Failed: No session exists.");
            return;
        }
        if (!this.session.isPaused()) {
            this.session.pause();
        }
        log.info((Object)"Firing Session Event: _session.stop");
        Long stopTime = this.session.getStopTime() == null ? 0L : this.session.getStopTime();
        AnalyticsEvent e = this.pinpointContext.getAnalyticsClient().createEvent(SESSION_STOP_EVENT_TYPE, this.session.getStartTime(), stopTime, this.session.getSessionDuration());
        this.pinpointContext.getAnalyticsClient().recordEvent(e);
        this.pinpointContext.getAnalyticsClient().clearCampaignAttributes();
        this.session = null;
    }

    protected void executePause() {
        if (this.session == null) {
            log.info((Object)"Session Stop Failed: No session exists.");
            return;
        }
        this.session.pause();
        log.debug((Object)("Session Paused: " + this.session.getSessionID()));
        log.info((Object)"Firing Session Event: _session.pause");
        AnalyticsEvent e = this.pinpointContext.getAnalyticsClient().createEvent(SESSION_PAUSE_EVENT_TYPE, this.session.getStartTime(), null, this.session.getSessionDuration());
        this.pinpointContext.getAnalyticsClient().recordEvent(e);
        this.pinpointContext.getSystem().getPreferences().putString(SHARED_PREFS_SESSION_KEY, this.session.toString());
    }

    protected void executeResume() {
        if (this.session == null) {
            return;
        }
        this.session.resume();
        log.debug((Object)"Firing Session Event: _session.resume");
        AnalyticsEvent e = this.pinpointContext.getAnalyticsClient().createEvent(SESSION_RESUME_EVENT_TYPE);
        this.pinpointContext.getAnalyticsClient().recordEvent(e);
        log.info((Object)("Session Resumed: " + this.session.getSessionID()));
    }

    protected Session getSession() {
        return this.session;
    }

    public long getRestartDelay() {
        return this.restartDelay;
    }

    public long getResumeDelay() {
        return this.resumeDelay;
    }

    protected SessionState getSessionState() {
        if (this.session != null) {
            return this.session.isPaused() ? SessionState.PAUSED : SessionState.ACTIVE;
        }
        return SessionState.INACTIVE;
    }

    protected static enum SessionState {
        INACTIVE,
        ACTIVE,
        PAUSED;

    }
}

