/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics;

import com.amazonaws.mobileconnectors.pinpoint.analytics.PinpointSession;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidAppDetails;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.system.AndroidDeviceDetails;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONSerializable;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.SDKInfo;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.ClientContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsEvent
implements JSONSerializable {
    static final int MAX_EVENT_ATTRIBUTE_METRIC_KEY_LENGTH = 50;
    static final int MAX_EVENT_ATTRIBUTE_VALUE_LENGTH = 1000;
    static final int MAX_NUM_OF_METRICS_AND_ATTRIBUTES = 50;
    private static final Log log = LogFactory.getLog(AnalyticsEvent.class);
    private static final int INDENTATION = 4;
    private final String eventId;
    private final String eventType;
    private final String sdkName;
    private final String sdkVersion;
    private final PinpointSession session;
    private final Map<String, String> attributes = new ConcurrentHashMap<String, String>();
    private final Map<String, Double> metrics = new ConcurrentHashMap<String, Double>();
    private final Long timestamp;
    private final String uniqueId;
    private final AndroidAppDetails appDetails;
    private final AndroidDeviceDetails deviceDetails;
    private final AtomicInteger currentNumOfAttributesAndMetrics = new AtomicInteger(0);

    AnalyticsEvent(String eventType, Map<String, String> attributes, Map<String, Double> metrics, SDKInfo sdkInfo, String sessionId, long sessionStart, Long sessionEnd, Long sessionDuration, long timestamp, String uniqueId, AndroidAppDetails appDetails, AndroidDeviceDetails deviceDetails) {
        this(UUID.randomUUID().toString(), eventType, attributes, metrics, sdkInfo, sessionId, sessionStart, sessionEnd, sessionDuration, timestamp, uniqueId, appDetails, deviceDetails);
    }

    private AnalyticsEvent(String eventId, String eventType, Map<String, String> attributes, Map<String, Double> metrics, SDKInfo sdkInfo, String sessionId, long sessionStart, Long sessionEnd, Long sessionDuration, long timestamp, String uniqueId, AndroidAppDetails appDetails, AndroidDeviceDetails deviceDetails) {
        this.eventId = eventId;
        this.sdkName = sdkInfo.getName();
        this.sdkVersion = sdkInfo.getVersion();
        this.session = new PinpointSession(sessionId, sessionStart, sessionEnd, sessionDuration);
        this.timestamp = timestamp;
        this.uniqueId = uniqueId;
        this.eventType = eventType;
        this.appDetails = appDetails;
        this.deviceDetails = deviceDetails;
        if (null != attributes) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.addAttribute(entry.getKey(), (String)entry.getValue());
            }
        }
        if (null != metrics) {
            for (Map.Entry<String, Object> entry : metrics.entrySet()) {
                this.addMetric(entry.getKey(), (Double)entry.getValue());
            }
        }
    }

    public static AnalyticsEvent createFromEvent(PinpointContext context, String sessionId, long timestamp, AnalyticsEvent copyEvent) {
        return new AnalyticsEvent(copyEvent.getEventId(), copyEvent.getEventType(), copyEvent.getAllAttributes(), copyEvent.getAllMetrics(), context.getSDKInfo(), sessionId, copyEvent.getSession().getSessionStart(), copyEvent.getSession().getSessionStop(), copyEvent.getSession().getSessionDuration(), timestamp, context.getUniqueId(), context.getSystem().getAppDetails(), context.getSystem().getDeviceDetails());
    }

    public static AnalyticsEvent newInstance(PinpointContext context, String sessionId, Long sessionStart, Long sessionEnd, Long duration, long timestamp, String eventType) {
        return new AnalyticsEvent(eventType, null, null, context.getSDKInfo(), sessionId, sessionStart, sessionEnd, duration, timestamp, context.getUniqueId(), context.getSystem().getAppDetails(), context.getSystem().getDeviceDetails());
    }

    public static AnalyticsEvent newInstance(String eventId, String eventType, Map<String, String> attributes, Map<String, Double> metrics, SDKInfo sdkInfo, String sessionId, Long sessionStart, Long sessionStop, Long sessionDuration, long timestamp, String uniqueId, AndroidAppDetails appDetails, AndroidDeviceDetails deviceDetails) {
        return new AnalyticsEvent(eventId, eventType, attributes, metrics, sdkInfo, sessionId, sessionStart, sessionStop, sessionDuration, timestamp, uniqueId, appDetails, deviceDetails);
    }

    private static String processAttributeMetricKey(String key) {
        String trimmedKey = StringUtil.clipString(key, 50, false);
        if (trimmedKey.length() < key.length()) {
            log.warn((Object)"The attribute key has been trimmed to a length of 50 characters.");
        }
        return trimmedKey;
    }

    private static String processAttributeValue(String value) {
        String trimmedValue = StringUtil.clipString(value, 1000, false);
        if (trimmedValue.length() < value.length()) {
            log.warn((Object)"The attribute value has been trimmed to a length of 1000 characters.");
        }
        return trimmedValue;
    }

    public static JSONObject translateFromEvent(AnalyticsEvent source) {
        if (null == source) {
            log.warn((Object)"The Event provided was null");
            return new JSONObject();
        }
        JSONObject json = source.toJSONObject();
        if (json.has("class")) {
            json.remove("class");
        }
        if (json.has("hashCode")) {
            json.remove("hashCode");
        }
        return json;
    }

    public static AnalyticsEvent translateToEvent(JSONObject source) throws JSONException {
        JSONObject metricsJSON;
        JSONObject attributesJSON;
        HashMap<String, String> attributes = new HashMap<String, String>();
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        AndroidAppDetails appDetails = new AndroidAppDetails(source.optString("app_package_name"), source.optString("app_version_code"), source.optString("app_version_name"), source.optString("app_title"), source.optString("app_id"));
        SDKInfo sdkInfo = new SDKInfo(source.optString("sdk_version"), source.optString("sdk_name"));
        AndroidDeviceDetails deviceDetails = new AndroidDeviceDetails(source.optString("carrier"));
        String eventId = source.getString("event_id");
        String eventType = source.getString("event_type");
        Long timestamp = source.getLong("timestamp");
        String uniqueId = source.getString("unique_id");
        String sessionId = "";
        Long sessionStart = null;
        Long sessionStop = null;
        Long sessionDuration = null;
        JSONObject sessionJSON = source.getJSONObject("session");
        if (sessionJSON != null) {
            sessionId = sessionJSON.getString("id");
            sessionStart = sessionJSON.getLong("startTimestamp");
            sessionStop = sessionJSON.optLong("stopTimestamp");
            sessionDuration = sessionJSON.optLong("duration");
        }
        if ((attributesJSON = source.optJSONObject("attributes")) != null) {
            Iterator keysIterator = attributesJSON.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                attributes.put(key, attributesJSON.optString(key));
            }
        }
        if ((metricsJSON = source.optJSONObject("metrics")) != null) {
            Iterator keysIterator = metricsJSON.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                try {
                    metrics.put(key, metricsJSON.getDouble(key));
                }
                catch (JSONException e) {
                    log.error((Object)"Failed to convert metric back to double from JSON value.");
                }
            }
        }
        return AnalyticsEvent.newInstance(eventId, eventType, attributes, metrics, sdkInfo, sessionId, sessionStart, sessionStop, sessionDuration, timestamp, uniqueId, appDetails, deviceDetails);
    }

    public String getEventId() {
        return this.eventId;
    }

    public void addAttribute(String name, String value) {
        if (null == name) {
            return;
        }
        if (null != value) {
            if (this.currentNumOfAttributesAndMetrics.get() < 50) {
                this.attributes.put(AnalyticsEvent.processAttributeMetricKey(name), AnalyticsEvent.processAttributeValue(value));
                this.currentNumOfAttributesAndMetrics.incrementAndGet();
            } else {
                log.warn((Object)"Max number of attributes/metrics reached(50).");
            }
        } else {
            this.attributes.remove(name);
        }
    }

    public boolean hasAttribute(String attributeName) {
        if (attributeName == null) {
            return false;
        }
        return this.attributes.containsKey(attributeName);
    }

    public void addMetric(String name, Double value) {
        if (null == name) {
            return;
        }
        if (null != value) {
            if (this.currentNumOfAttributesAndMetrics.get() < 50) {
                this.metrics.put(AnalyticsEvent.processAttributeMetricKey(name), value);
                this.currentNumOfAttributesAndMetrics.incrementAndGet();
            } else {
                log.warn((Object)"Max number of attributes/metrics reached(50).");
            }
        } else {
            this.metrics.remove(name);
        }
    }

    public boolean hasMetric(String metricName) {
        if (metricName == null) {
            return false;
        }
        return this.metrics.containsKey(metricName);
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Double getMetric(String name) {
        if (name == null) {
            return null;
        }
        return this.metrics.get(name);
    }

    public PinpointSession getSession() {
        return this.session;
    }

    public Long getEventTimestamp() {
        return this.timestamp;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public AnalyticsEvent withAttribute(String name, String value) {
        this.addAttribute(name, value);
        return this;
    }

    public AnalyticsEvent withMetric(String name, Double value) {
        this.addMetric(name, value);
        return this;
    }

    public Map<String, String> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public Map<String, Double> getAllMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public String toString() {
        JSONObject json = this.toJSONObject();
        try {
            return json.toString(4);
        }
        catch (JSONException e) {
            return json.toString();
        }
    }

    @Override
    public JSONObject toJSONObject() {
        Locale locale = this.deviceDetails.locale();
        String localeString = locale != null ? locale.toString() : "UNKNOWN";
        JSONBuilder builder = new JSONBuilder(this);
        builder.withAttribute("event_id", this.getEventId());
        builder.withAttribute("event_type", this.getEventType());
        builder.withAttribute("unique_id", this.getUniqueId());
        builder.withAttribute("timestamp", this.getEventTimestamp());
        builder.withAttribute("platform", this.deviceDetails.platform());
        builder.withAttribute("platform_version", this.deviceDetails.platformVersion());
        builder.withAttribute("make", this.deviceDetails.manufacturer());
        builder.withAttribute("model", this.deviceDetails.model());
        builder.withAttribute("locale", localeString);
        builder.withAttribute("carrier", this.deviceDetails.carrier());
        JSONObject sessionObject = new JSONObject();
        try {
            sessionObject.put("id", (Object)this.session.getSessionId());
            if (this.session.getSessionStart() != null) {
                sessionObject.put("startTimestamp", (Object)this.session.getSessionStart());
            }
            if (this.session.getSessionStop() != null) {
                sessionObject.put("stopTimestamp", (Object)this.session.getSessionStop());
            }
            if (this.session.getSessionDuration() != null) {
                sessionObject.put("duration", this.session.getSessionDuration().longValue());
            }
        }
        catch (JSONException e) {
            log.error((Object)"Error serializing session information", (Throwable)e);
        }
        builder.withAttribute("session", sessionObject);
        builder.withAttribute("sdk_version", this.sdkVersion);
        builder.withAttribute("sdk_name", this.sdkName);
        builder.withAttribute("app_version_name", this.appDetails.versionName());
        builder.withAttribute("app_version_code", this.appDetails.versionCode());
        builder.withAttribute("app_package_name", this.appDetails.packageName());
        builder.withAttribute("app_title", this.appDetails.getAppTitle());
        builder.withAttribute("app_id", this.appDetails.getAppId());
        JSONObject attributesJson = new JSONObject();
        for (Map.Entry<String, String> entry : this.getAllAttributes().entrySet()) {
            try {
                attributesJson.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                log.error((Object)("Error serializing attribute for eventType: " + this.eventType));
            }
        }
        JSONObject metricsJson = new JSONObject();
        for (Map.Entry<String, Double> entry : this.getAllMetrics().entrySet()) {
            try {
                metricsJson.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                log.error((Object)("Error serializing metric for eventType: " + this.eventType));
            }
        }
        if (attributesJson.length() > 0) {
            builder.withAttribute("attributes", attributesJson);
        }
        if (metricsJson.length() > 0) {
            builder.withAttribute("metrics", metricsJson);
        }
        return builder.toJSONObject();
    }

    public ClientContext createClientContext(String networkType) {
        ClientContext.ClientContextBuilder builder = new ClientContext.ClientContextBuilder();
        builder.withAppPackageName(this.appDetails.packageName()).withAppVersionCode(this.appDetails.versionCode()).withAppVersionName(this.appDetails.versionName()).withLocale(this.deviceDetails.locale().toString()).withMake(this.deviceDetails.manufacturer()).withModel(this.deviceDetails.model()).withPlatformVersion(this.deviceDetails.platformVersion()).withUniqueId(this.uniqueId).withAppTitle(this.appDetails.getAppTitle()).withNetworkType(networkType).withCarrier(this.deviceDetails.carrier()).withAppId(this.appDetails.getAppId());
        return builder.build();
    }
}

