/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint.analytics;

import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.JSONSerializable;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.pinpoint.internal.event.EventRecorder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsClient
implements JSONSerializable {
    private static final Log log = LogFactory.getLog(AnalyticsClient.class);
    private static final String ANALYTICS_ENABLED = "isAnalyticsEnabled";
    private static final int MAX_EVENT_TYPE_LENGTH = 50;
    private static final int INDENTATION = 4;
    private final PinpointContext context;
    private final Map<String, String> globalAttributes = new ConcurrentHashMap<String, String>();
    private final Map<String, Double> globalMetrics = new ConcurrentHashMap<String, Double>();
    private final Map<String, Map<String, String>> eventTypeAttributes = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, Double>> eventTypeMetrics = new ConcurrentHashMap<String, Map<String, Double>>();
    private Map<String, String> campaignAttributes = new ConcurrentHashMap<String, String>();
    private String sessionId;
    private long sessionStartTime;
    private EventRecorder eventRecorder;

    public AnalyticsClient(PinpointContext context) {
        Preconditions.checkNotNull(context, "A valid pinpointContext must be provided");
        this.context = context;
        this.eventRecorder = EventRecorder.newInstance(context);
    }

    public AnalyticsEvent createEvent(String eventType) {
        if (eventType == null) {
            log.error((Object)"Null eventType provided to addGlobalAttribute.");
            throw new IllegalArgumentException("The eventType passed into create event was null");
        }
        if (eventType.length() > 50) {
            log.error((Object)"The event type is too long, the max event type length is 50 characters.");
            throw new IllegalArgumentException("The eventType passed into create event was too long");
        }
        return this.createEvent(eventType, this.sessionStartTime, null, null);
    }

    protected AnalyticsEvent createEvent(String eventType, long sessionStart, Long sessionEnd, Long sessionDuration) {
        AnalyticsEvent event = AnalyticsEvent.newInstance(this.context, this.sessionId, sessionStart, sessionEnd, sessionDuration, System.currentTimeMillis(), eventType);
        for (Map.Entry<String, String> entry : this.globalAttributes.entrySet()) {
            event.addAttribute(entry.getKey(), entry.getValue());
        }
        if (this.eventTypeAttributes.containsKey(event.getEventType())) {
            for (Map.Entry<String, Object> entry : this.eventTypeAttributes.get(event.getEventType()).entrySet()) {
                event.addAttribute(entry.getKey(), (String)entry.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.globalMetrics.entrySet()) {
            event.addMetric(entry.getKey(), (Double)entry.getValue());
        }
        if (this.eventTypeMetrics.containsKey(event.getEventType())) {
            for (Map.Entry<String, Object> entry : this.eventTypeMetrics.get(event.getEventType()).entrySet()) {
                event.addMetric(entry.getKey(), (Double)entry.getValue());
            }
        }
        return event;
    }

    public void recordEvent(AnalyticsEvent event) {
        if (event == null) {
            log.info((Object)"The provided event was null.");
            return;
        }
        AnalyticsEvent recordEvent = AnalyticsEvent.createFromEvent(this.context, this.sessionId, System.currentTimeMillis(), event);
        this.eventRecorder.recordEvent(recordEvent);
    }

    public void submitEvents() {
        log.info((Object)"Submitting events.");
        this.eventRecorder.submitEvents();
    }

    public void addGlobalAttribute(String attributeName, String attributeValue) {
        if (attributeName == null) {
            log.info((Object)"Null attribute name provided to addGlobalAttribute.");
            return;
        }
        if (attributeValue == null) {
            log.debug((Object)"Null attribute value provided to addGlobalAttribute.");
            return;
        }
        this.globalAttributes.put(attributeName, attributeValue);
    }

    public void addGlobalAttribute(String eventType, String attributeName, String attributeValue) {
        if (eventType == null) {
            log.warn((Object)"Null eventType provided to addGlobalAttribute.");
            return;
        }
        if (attributeName == null) {
            log.warn((Object)("Null attribute name provided to addGlobalAttribute. eventType:" + eventType));
            return;
        }
        if (attributeValue == null) {
            log.warn((Object)("Null value provided to addGlobalAttribute. eventType:" + eventType));
            return;
        }
        Map<String, String> eventAttrs = this.eventTypeAttributes.get(eventType);
        if (eventAttrs == null) {
            eventAttrs = new ConcurrentHashMap<String, String>();
            this.eventTypeAttributes.put(eventType, eventAttrs);
        }
        eventAttrs.put(attributeName, attributeValue);
    }

    public void addGlobalMetric(String metricName, Double metricValue) {
        if (metricName == null) {
            log.warn((Object)"Null metric name provided to addGlobalMetric.");
            return;
        }
        if (metricValue == null) {
            log.warn((Object)"Null metric value provided to addGlobalMetric.");
            return;
        }
        this.globalMetrics.put(metricName, metricValue);
    }

    public void addGlobalMetric(String eventType, String metricName, Double metricValue) {
        if (eventType == null) {
            log.warn((Object)"Null eventType provided to addGlobalMetric.");
            return;
        }
        if (metricName == null) {
            log.warn((Object)("Null metric name provided to addGlobalMetric. eventType:" + eventType));
            return;
        }
        if (metricValue == null) {
            log.warn((Object)("Null metric value provided to addGlobalMetric. eventType:" + eventType));
            return;
        }
        Map<String, Double> eventMetrics = this.eventTypeMetrics.get(eventType);
        if (eventMetrics == null) {
            eventMetrics = new ConcurrentHashMap<String, Double>();
            this.eventTypeMetrics.put(eventType, eventMetrics);
        }
        eventMetrics.put(metricName, metricValue);
    }

    public void removeGlobalAttribute(String attributeName) {
        if (attributeName == null) {
            log.warn((Object)"Null attribute name provided to removeGlobalAttribute.");
            return;
        }
        this.globalAttributes.remove(attributeName);
    }

    public void removeGlobalAttribute(String eventType, String attributeName) {
        if (eventType == null) {
            log.warn((Object)"Null eventType provided to removeGlobalAttribute.");
            return;
        }
        if (attributeName == null) {
            log.warn((Object)"Null attribute name provided to removeGlobalAttribute.");
            return;
        }
        Map<String, String> eventAttrs = this.eventTypeAttributes.get(eventType);
        if (eventAttrs != null) {
            eventAttrs.remove(attributeName);
        }
    }

    public void removeGlobalMetric(String metricName) {
        if (metricName == null) {
            log.warn((Object)"Null metric name provided to removeGlobalMetric.");
            return;
        }
        this.globalMetrics.remove(metricName);
    }

    public void removeGlobalMetric(String eventType, String metricName) {
        if (eventType == null) {
            log.warn((Object)"Null eventType provided to removeGlobalMetric.");
            return;
        }
        if (metricName == null) {
            log.warn((Object)"Null metric name provided to removeGlobalMetric.");
            return;
        }
        Map<String, Double> eventMetrics = this.eventTypeMetrics.get(eventType);
        if (eventMetrics != null) {
            eventMetrics.remove(metricName);
        }
    }

    public void setCampaignAttributes(Map<String, String> campaign) {
        if (campaign == null) {
            log.warn((Object)"Null campaign attributes provided to setCampaignAttributes.");
            return;
        }
        this.campaignAttributes = campaign;
    }

    public void clearCampaignAttributes() {
        for (String key : this.campaignAttributes.keySet()) {
            this.removeGlobalAttribute(key);
        }
        this.campaignAttributes.clear();
    }

    public String toString() {
        JSONObject json = this.toJSONObject();
        try {
            return json.toString(4);
        }
        catch (JSONException e) {
            return json.toString();
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONArray observersJSON = new JSONArray();
        JSONArray globalAttrs = new JSONArray();
        if (null != this.globalAttributes) {
            for (Map.Entry<String, String> entry : this.globalAttributes.entrySet()) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(entry.getKey(), (Object)entry.getValue());
                    globalAttrs.put((Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    log.error((Object)"Error parsing Global Attributes.");
                }
            }
        }
        JSONArray globalMets = new JSONArray();
        if (null != this.globalMetrics) {
            for (Map.Entry<String, Double> entry : this.globalMetrics.entrySet()) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(entry.getKey(), (Object)entry.getValue());
                    globalMets.put((Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    log.error((Object)"Error parsing Global Metrics.");
                }
            }
        }
        JSONObject jSONObject = new JSONObject();
        if (null != this.eventTypeAttributes) {
            for (Map.Entry<String, Map<String, String>> entry : this.eventTypeAttributes.entrySet()) {
                JSONArray eventTypeAttrs = new JSONArray();
                try {
                    for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put(entry2.getKey(), (Object)entry2.getValue());
                        eventTypeAttrs.put((Object)jSONObject2);
                    }
                    jSONObject.put(entry.getKey(), (Object)eventTypeAttrs);
                }
                catch (JSONException e) {
                    log.error((Object)"Error parsing Event Type Attributes.");
                }
            }
        }
        JSONObject jSONObject3 = new JSONObject();
        if (null != this.eventTypeMetrics) {
            for (Map.Entry<String, Map<String, Double>> entry : this.eventTypeMetrics.entrySet()) {
                JSONArray eventTypeMets = new JSONArray();
                try {
                    for (Map.Entry<String, Double> entry3 : entry.getValue().entrySet()) {
                        JSONObject attr = new JSONObject();
                        attr.put(entry3.getKey(), (Object)entry3.getValue());
                        eventTypeMets.put((Object)attr);
                    }
                    jSONObject3.put(entry.getKey(), (Object)eventTypeMets);
                }
                catch (JSONException jSONException) {
                    log.error((Object)"Error parsing Event Type Metrics.");
                }
            }
        }
        return new JSONBuilder(this).withAttribute("uniqueId", this.context.getUniqueId()).withAttribute("observers", observersJSON).withAttribute("globalAttributes", globalAttrs).withAttribute("globalMetrics", globalMets).withAttribute("eventTypeAttributes", jSONObject).withAttribute("eventTypeMetrics", jSONObject3).toJSONObject();
    }

    public void closeDB() {
        this.eventRecorder.closeDB();
    }

    public List<JSONObject> getAllEvents() {
        return this.eventRecorder.getAllEvents();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public void setSessionStartTime(long sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
    }

    void setEventRecorder(EventRecorder eventRecorder) {
        this.eventRecorder = eventRecorder;
    }
}

