/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint;

import android.content.Context;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobileconnectors.pinpoint.PinpointCallback;
import com.amazonaws.mobileconnectors.pinpoint.PinpointConfiguration;
import com.amazonaws.mobileconnectors.pinpoint.analytics.AnalyticsClient;
import com.amazonaws.mobileconnectors.pinpoint.analytics.SessionClient;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.PinpointContext;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.pinpoint.internal.core.util.SDKInfo;
import com.amazonaws.mobileconnectors.pinpoint.internal.validate.EncodingValidator;
import com.amazonaws.mobileconnectors.pinpoint.internal.validate.PermissionValidator;
import com.amazonaws.mobileconnectors.pinpoint.targeting.TargetingClient;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.GCMTokenRegisteredHandler;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.NotificationClient;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.PinpointNotificationReceiver;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.pinpoint.AmazonPinpointClient;
import com.amazonaws.services.pinpointanalytics.AmazonPinpointAnalyticsClient;
import com.amazonaws.util.VersionInfoUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PinpointManager {
    private static final String SDK_VERSION = VersionInfoUtils.getVersion();
    private static final String SDK_NAME = "PinpointSDK";
    private static final SDKInfo SDL_INFO = new SDKInfo("PinpointSDK", SDK_VERSION);
    private static final Log log = LogFactory.getLog(PinpointManager.class);
    private static final PermissionValidator INTERNET_PERMISSION_VALIDATOR = new PermissionValidator("android.permission.INTERNET");
    private static final PermissionValidator ACCESS_NETWORK_STATE_PERMISSION_VALIDATOR = new PermissionValidator("android.permission.ACCESS_NETWORK_STATE");
    private static final EncodingValidator ENCODING_VALIDATOR = new EncodingValidator("UTF-8");
    private final PinpointContext pinpointContext;
    private final AnalyticsClient analyticsClient;
    private final SessionClient sessionClient;
    private final TargetingClient targetingClient;
    private final NotificationClient notificationClient;

    public PinpointManager(PinpointConfiguration config) {
        try {
            Preconditions.checkNotNull(config, "The config provided must not be null");
            AWSCredentialsProvider credentialsProvider = config.getCredentialsProvider();
            Context appContext = config.getAppContext();
            String appId = config.getAppId();
            Regions region = config.getRegion();
            PinpointCallback<PinpointManager> initCompletionCallback = config.getInitCompletionCallback();
            Preconditions.checkNotNull(credentialsProvider, "The credentialsProvider provided must not be null");
            Preconditions.checkNotNull(appContext, "The application pinpointContext provided must not be null");
            Preconditions.checkNotNull(appId, "The app ID specified must not be null");
            AmazonPinpointAnalyticsClient analyticsServiceClient = new AmazonPinpointAnalyticsClient(credentialsProvider, config.getClientConfiguration());
            AmazonPinpointClient targetingServiceClient = new AmazonPinpointClient(credentialsProvider, config.getClientConfiguration());
            INTERNET_PERMISSION_VALIDATOR.validate(appContext);
            ACCESS_NETWORK_STATE_PERMISSION_VALIDATOR.validate(appContext);
            ENCODING_VALIDATOR.validate();
            this.pinpointContext = new PinpointContext(analyticsServiceClient, targetingServiceClient, appContext, appId, SDL_INFO, config);
            this.notificationClient = new NotificationClient(this.pinpointContext);
            this.pinpointContext.setNotificationClient(this.notificationClient);
            PinpointNotificationReceiver.setNotificationClient(this.notificationClient);
            if (config.getEnableEvents()) {
                this.analyticsClient = new AnalyticsClient(this.pinpointContext);
                this.pinpointContext.setAnalyticsClient(this.analyticsClient);
                this.sessionClient = new SessionClient(this.pinpointContext);
                this.pinpointContext.setSessionClient(this.sessionClient);
            } else {
                this.analyticsClient = null;
                this.sessionClient = null;
            }
            if (config.getEnableTargeting()) {
                this.targetingClient = new TargetingClient(this.pinpointContext);
                this.pinpointContext.setTargetingClient(this.targetingClient);
                this.notificationClient.addGCMTokenRegisteredHandler(new GCMTokenRegisteredHandler(){

                    @Override
                    public void tokenRegistered(String deviceToken) {
                        PinpointManager.this.targetingClient.updateEndpointProfile();
                    }
                });
            } else {
                this.targetingClient = null;
            }
            if (initCompletionCallback != null) {
                initCompletionCallback.onComplete(this);
            }
            log.debug((Object)String.format("Pinpoint SDK(%s) initialization successfully completed", SDK_VERSION));
        }
        catch (RuntimeException e) {
            log.debug((Object)"Cannot initialize Pinpoint SDK", (Throwable)e);
            throw new AmazonClientException(e.getLocalizedMessage());
        }
    }

    public PinpointContext getPinpointContext() {
        return this.pinpointContext;
    }

    public AnalyticsClient getAnalyticsClient() {
        return this.analyticsClient;
    }

    public TargetingClient getTargetingClient() {
        return this.targetingClient;
    }

    public SessionClient getSessionClient() {
        return this.sessionClient;
    }

    public NotificationClient getNotificationClient() {
        return this.notificationClient;
    }
}

