/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.pinpoint;

import android.content.Context;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.mobile.config.AWSConfiguration;
import com.amazonaws.mobileconnectors.pinpoint.PinpointCallback;
import com.amazonaws.mobileconnectors.pinpoint.PinpointManager;
import com.amazonaws.mobileconnectors.pinpoint.targeting.notification.AppLevelOptOutProvider;
import com.amazonaws.regions.Regions;
import org.json.JSONObject;

public class PinpointConfiguration {
    private Context context;
    private String appId;
    private Regions region;
    private boolean enableEvents = true;
    private boolean enableTargeting = true;
    private boolean shouldPostNotificationsInForeground = false;
    private ClientConfiguration clientConfiguration = new ClientConfiguration();
    private AWSCredentialsProvider credentialsProvider;
    private PinpointCallback<PinpointManager> initCompletionCallback;
    private AppLevelOptOutProvider appLevelOptOutProvider;

    public PinpointConfiguration(Context context, String appId, Regions region, AWSCredentialsProvider credentialsProvider) {
        this.context = context;
        this.appId = appId;
        this.credentialsProvider = credentialsProvider;
        this.region = region;
    }

    public PinpointConfiguration(Context context, AWSCredentialsProvider credentialsProvider, AWSConfiguration awsConfiguration) {
        this.context = context;
        try {
            JSONObject pinpointConfig = awsConfiguration.optJsonObject("PinpointAnalytics");
            this.appId = pinpointConfig.getString("AppId");
            this.region = Regions.fromName((String)pinpointConfig.getString("Region"));
            String userAgent = awsConfiguration.getUserAgent();
            String currentUserAgent = this.clientConfiguration.getUserAgent();
            String string = currentUserAgent = currentUserAgent != null ? currentUserAgent : "";
            if (userAgent != null) {
                this.clientConfiguration.setUserAgent(currentUserAgent.trim() + " " + userAgent);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read AppId or Region from AWSConfiguration please check your setup or awsconfiguration.json file", e);
        }
        this.credentialsProvider = credentialsProvider;
    }

    public PinpointConfiguration withClientConfiguration(ClientConfiguration clientConfig) {
        this.clientConfiguration = new ClientConfiguration(clientConfig);
        return this;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public PinpointConfiguration withAllowsEventCollection(boolean allowEventCollection) {
        this.enableEvents = allowEventCollection;
        return this;
    }

    public boolean getEnableEvents() {
        return this.enableEvents;
    }

    public boolean getEnableTargeting() {
        return this.enableTargeting;
    }

    public PinpointConfiguration withEnablePinpoint(boolean enablePinpoint) {
        this.enableTargeting = enablePinpoint;
        return this;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public PinpointConfiguration withCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public Context getAppContext() {
        return this.context;
    }

    public PinpointConfiguration withAppContext(Context context) {
        this.context = context;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public PinpointConfiguration withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public Regions getRegion() {
        return this.region;
    }

    public PinpointConfiguration withRegion(Regions region) {
        this.region = region;
        return this;
    }

    public PinpointCallback<PinpointManager> getInitCompletionCallback() {
        return this.initCompletionCallback;
    }

    public PinpointConfiguration withInitCompletionCallback(PinpointCallback<PinpointManager> initCompletionCallback) {
        this.initCompletionCallback = initCompletionCallback;
        return this;
    }

    public AppLevelOptOutProvider getAppLevelOptOutProvider() {
        return this.appLevelOptOutProvider;
    }

    public PinpointConfiguration withAppLevelOptOutProvider(AppLevelOptOutProvider appLevelOptOutProvider) {
        this.appLevelOptOutProvider = appLevelOptOutProvider;
        return this;
    }

    public PinpointConfiguration withPostNotificationsInForeground(boolean shouldPostNotificationsInForeground) {
        this.shouldPostNotificationsInForeground = shouldPostNotificationsInForeground;
        return this;
    }

    public boolean getShouldPostNotificationsInForeground() {
        return this.shouldPostNotificationsInForeground;
    }
}

