/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.service;

import cn.vonce.sql.bean.Alter;
import cn.vonce.sql.bean.Column;
import cn.vonce.sql.bean.ColumnInfo;
import cn.vonce.sql.bean.Delete;
import cn.vonce.sql.bean.Insert;
import cn.vonce.sql.bean.Paging;
import cn.vonce.sql.bean.Select;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.bean.Update;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.config.SqlBeanDB;
import cn.vonce.sql.define.ColumnFun;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.exception.SqlBeanException;
import cn.vonce.sql.helper.Wrapper;
import cn.vonce.sql.page.PageHelper;
import cn.vonce.sql.page.PagingService;
import cn.vonce.sql.page.ResultData;
import cn.vonce.sql.provider.SqlBeanProvider;
import cn.vonce.sql.service.AdvancedDbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.spring.annotation.DbSwitch;
import cn.vonce.sql.spring.annotation.DbTransactional;
import cn.vonce.sql.spring.config.UseMybatis;
import cn.vonce.sql.spring.dao.MybatisSqlBeanDao;
import cn.vonce.sql.spring.enumerate.DbRole;
import cn.vonce.sql.spring.service.BaseSqlBeanServiceImpl;
import cn.vonce.sql.uitls.DateUtil;
import cn.vonce.sql.uitls.SqlBeanUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@UseMybatis
@Service
public class MybatisSqlBeanServiceImpl<T, ID>
extends BaseSqlBeanServiceImpl
implements SqlBeanService<T, ID>,
AdvancedDbManageService<T> {
    private Logger logger = LoggerFactory.getLogger(MybatisSqlBeanServiceImpl.class);
    @Autowired
    private MybatisSqlBeanDao<T> mybatisSqlBeanDao;
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;
    @Autowired
    private SqlSession sqlSession;
    private boolean initDBInfo;
    private Class<?> clazz = SqlBeanUtil.getGenericType(this.getClass());

    @Override
    SqlBeanConfig getSqlBeanConfig() {
        return this.sqlBeanConfig;
    }

    @Override
    SqlBeanDB initDBInfo() {
        SqlBeanDB sqlBeanDB = new SqlBeanDB();
        if (!this.initDBInfo) {
            try {
                Connection connection = this.sqlSession.getConfiguration().getEnvironment().getDataSource().getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                super.sqlBeanDBFill(sqlBeanDB, metaData);
                connection.close();
                this.initDBInfo = true;
            }
            catch (SQLException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return sqlBeanDB;
    }

    @Override
    Long getAutoIncrId() {
        if (this.getSqlBeanDB().getDbType() == DbType.MySQL || this.getSqlBeanDB().getDbType() == DbType.MariaDB) {
            return this.mybatisSqlBeanDao.lastInsertId();
        }
        return null;
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectById(ID id) {
        if (id == null) {
            return null;
        }
        return this.mybatisSqlBeanDao.selectById(this.getSqlBeanDB(), this.clazz, id);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectById(Class<R> returnType, ID id) {
        if (id == null) {
            return null;
        }
        return this.mybatisSqlBeanDao.selectByIdO(this.getSqlBeanDB(), this.clazz, returnType, id);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectByIds(ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.selectByIds(this.getSqlBeanDB(), this.clazz, ids);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectByIds(Class<R> returnType, ID ... ids) {
        if (ids == null || ids.length == 0) {
            throw new SqlBeanException("selectByIds\u65b9\u6cd5ids\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.selectByIdsO(this.getSqlBeanDB(), this.clazz, returnType, ids);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOne(Select select) {
        return this.mybatisSqlBeanDao.selectOne(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOne(Class<R> returnType, Select select) {
        return this.mybatisSqlBeanDao.selectOneO(this.getSqlBeanDB(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public Map<String, Object> selectMap(Select select) {
        return this.mybatisSqlBeanDao.selectMap(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectOneBy(this.getSqlBeanDB(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectOneByO(this.getSqlBeanDB(), this.clazz, returnType, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public T selectOneBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.selectOne(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> R selectOneBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.selectOneO(this.getSqlBeanDB(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectByO(this.getSqlBeanDB(), this.clazz, returnType, null, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.selectO(this.getSqlBeanDB(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectByO(this.getSqlBeanDB(), this.clazz, returnType, paging, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> selectBy(Class<R> returnType, Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.mybatisSqlBeanDao.selectO(this.getSqlBeanDB(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectBy(this.getSqlBeanDB(), this.clazz, null, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.select(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, String where, Object ... args) {
        return this.mybatisSqlBeanDao.selectBy(this.getSqlBeanDB(), this.clazz, paging, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> selectBy(Paging paging, Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        select.page(paging.getPagenum(), paging.getPagesize(), paging.getStartByZero());
        select.orderBy(paging.getOrders());
        return this.mybatisSqlBeanDao.select(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.countBy(this.getSqlBeanDB(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int countBy(Wrapper wrapper) {
        Select select = new Select();
        select.where(wrapper);
        return this.mybatisSqlBeanDao.count(this.getSqlBeanDB(), this.clazz, null, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count() {
        return this.mybatisSqlBeanDao.countBy(this.getSqlBeanDB(), this.clazz, null, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<T> select() {
        return this.mybatisSqlBeanDao.selectAll(this.getSqlBeanDB(), this.clazz, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<T> select(Paging paging) {
        return this.mybatisSqlBeanDao.selectAll(this.getSqlBeanDB(), this.clazz, paging);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> List<R> select(Class<R> returnType) {
        return this.mybatisSqlBeanDao.selectAllO(this.getSqlBeanDB(), this.clazz, returnType, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> List<R> select(Class<R> returnType, Paging paging) {
        return this.mybatisSqlBeanDao.selectAllO(this.getSqlBeanDB(), this.clazz, returnType, paging);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<Map<String, Object>> selectMapList(Select select) {
        return this.mybatisSqlBeanDao.selectMapList(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> List<R> select(Class<R> returnType, Select select) {
        return this.mybatisSqlBeanDao.selectO(this.getSqlBeanDB(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<T> select(Select select) {
        return this.mybatisSqlBeanDao.select(this.getSqlBeanDB(), this.clazz, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Select select) {
        return this.mybatisSqlBeanDao.count(this.getSqlBeanDB(), this.clazz, null, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public int count(Class<?> returnType, Select select) {
        return this.mybatisSqlBeanDao.count(this.getSqlBeanDB(), this.clazz, returnType, select);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, PageHelper<T> pageHelper) {
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public ResultData<T> paging(Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> returnType, Select select, PageHelper<R> pageHelper) {
        pageHelper.paging(returnType, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public <R> ResultData<R> paging(Class<R> returnType, Select select, int pagenum, int pagesize) {
        PageHelper pageHelper = new PageHelper(Integer.valueOf(pagenum), Integer.valueOf(pagesize));
        pageHelper.paging(returnType, select, (PagingService)this);
        return pageHelper.getResultData();
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("deleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.deleteById(this.getSqlBeanDB(), this.clazz, id);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.deleteBy(this.getSqlBeanDB(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int deleteBy(Wrapper wrapper) {
        Delete delete = new Delete();
        delete.where(wrapper);
        return this.mybatisSqlBeanDao.delete(this.getSqlBeanDB(), this.clazz, delete, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete) {
        return this.mybatisSqlBeanDao.delete(this.getSqlBeanDB(), this.clazz, delete, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int delete(Delete delete, boolean ignore) {
        return this.mybatisSqlBeanDao.delete(this.getSqlBeanDB(), this.clazz, delete, ignore);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteById(ID ... id) {
        if (id == null || id.length == 0) {
            throw new SqlBeanException("logicallyDeleteById\u65b9\u6cd5id\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        return this.mybatisSqlBeanDao.logicallyDeleteById(this.getSqlBeanDB(), this.clazz, id);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(String where, Object ... args) {
        return this.mybatisSqlBeanDao.logicallyDeleteBy(this.getSqlBeanDB(), this.clazz, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int logicallyDeleteBy(Wrapper wrapper) {
        return this.mybatisSqlBeanDao.logicallyDeleteByWrapper(this.getSqlBeanDB(), this.clazz, wrapper);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update<T> update) {
        return this.mybatisSqlBeanDao.update(this.getSqlBeanDB(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int update(Update<T> update, boolean ignore) {
        return this.mybatisSqlBeanDao.update(this.getSqlBeanDB(), this.clazz, update, ignore);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanDB(), this.clazz, bean, id, true, false, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanDB(), this.clazz, bean, id, updateNotNull, optimisticLock, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanDB(), this.clazz, bean, true, false, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanDB(), this.clazz, bean, id, updateNotNull, optimisticLock, filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateById(T bean, ID id, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.mybatisSqlBeanDao.updateById(this.getSqlBeanDB(), this.clazz, bean, id, updateNotNull, optimisticLock, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, String where, Object ... args) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanDB(), this.clazz, bean, true, false, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, Column ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateByBeanId(T bean, boolean updateNotNull, boolean optimisticLock, ColumnFun<T, R> ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBeanId(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, String where, Object ... args) {
        return this.mybatisSqlBeanDao.updateBy(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, null, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, Wrapper wrapper) {
        Update update = new Update();
        update.bean(bean).notNull(true).optimisticLock(false).where(wrapper);
        return this.mybatisSqlBeanDao.update(this.getSqlBeanDB(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper) {
        Update update = new Update();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).where(wrapper);
        return this.mybatisSqlBeanDao.update(this.getSqlBeanDB(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Column[] filterColumns, String where, Object ... args) {
        return this.mybatisSqlBeanDao.updateBy(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, filterColumns, where, args);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, Column ... filterColumns) {
        Update update = new Update();
        update.bean(bean).notNull(updateNotNull).optimisticLock(optimisticLock).filterFields(filterColumns).where(wrapper);
        return this.mybatisSqlBeanDao.update(this.getSqlBeanDB(), this.clazz, update, false);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateBy(T bean, boolean updateNotNull, boolean optimisticLock, Wrapper wrapper, ColumnFun<T, R> ... filterColumns) {
        return this.updateBy(bean, updateNotNull, optimisticLock, wrapper, SqlBeanUtil.funToColumn(filterColumns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, String where) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanDB(), this.clazz, bean, true, false, where, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, where, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, Column ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, where, filterColumns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int updateByBean(T bean, boolean updateNotNull, boolean optimisticLock, String where, ColumnFun<T, R> ... filterColumns) {
        return this.mybatisSqlBeanDao.updateByBean(this.getSqlBeanDB(), this.clazz, bean, updateNotNull, optimisticLock, where, SqlBeanUtil.funToColumn(filterColumns));
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(T ... bean) {
        if (bean == null || bean.length == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5bean\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        List<T> beanList = Arrays.asList(bean);
        int count = this.mybatisSqlBeanDao.insertBean(this.getSqlBeanDB(), this.clazz, beanList);
        super.setAutoIncrId(this.clazz, beanList);
        return count;
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(Collection<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            throw new SqlBeanException("insert\u65b9\u6cd5beanList\u53c2\u6570\u81f3\u5c11\u62e5\u6709\u4e00\u4e2a\u503c");
        }
        int count = this.mybatisSqlBeanDao.insertBean(this.getSqlBeanDB(), this.clazz, beanList);
        super.setAutoIncrId(this.clazz, beanList);
        return count;
    }

    @Transactional
    @DbTransactional
    @DbSwitch(value=DbRole.MASTER)
    public int insert(Insert<T> insert) {
        int count = this.mybatisSqlBeanDao.insert(this.getSqlBeanDB(), this.clazz, insert);
        super.setAutoIncrId(this.clazz, insert.getBean());
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public String backup() {
        String targetTableName = SqlBeanUtil.getTable(this.clazz).getName() + "_" + DateUtil.dateToString((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, null, null, targetTableName, null);
        return targetTableName;
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetTableName) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, null, null, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(String targetSchema, String targetTableName) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, null, targetSchema, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, wrapper, targetSchema, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetTableName, Column ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, wrapper, null, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, wrapper, null, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public void backup(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, wrapper, targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> void backup(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        this.mybatisSqlBeanDao.backup(this.getSqlBeanDB(), this.clazz, wrapper, targetSchema, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetTableName) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanDB(), this.clazz, wrapper, null, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanDB(), this.clazz, wrapper, targetSchema, targetTableName, null);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetTableName, Column ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanDB(), this.clazz, wrapper, null, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(Wrapper wrapper, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanDB(), this.clazz, wrapper, null, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int copy(Wrapper wrapper, String targetSchema, String targetTableName, Column ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanDB(), this.clazz, wrapper, targetSchema, targetTableName, columns);
    }

    @DbSwitch(value=DbRole.MASTER)
    public <R> int copy(Wrapper wrapper, String targetSchema, String targetTableName, ColumnFun<T, R> ... columns) {
        return this.mybatisSqlBeanDao.copy(this.getSqlBeanDB(), this.clazz, wrapper, targetSchema, targetTableName, SqlBeanUtil.funToColumn(columns));
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(Table table, List<ColumnInfo> columnInfoList) {
        List sqlList = SqlBeanProvider.buildAlterSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, columnInfoList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.mybatisSqlBeanDao.executeSql(sql);
            }
        }
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(Alter alter) {
        ArrayList<Alter> alterList = new ArrayList<Alter>();
        alterList.add(alter);
        return this.alter(alterList);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alter(List<Alter> alterList) {
        List sqlList = SqlBeanProvider.alterSql((DbType)this.getSqlBeanDB().getDbType(), alterList);
        int count = 0;
        if (sqlList != null && sqlList.size() > 0) {
            for (String sql : sqlList) {
                count += this.mybatisSqlBeanDao.executeSql(sql);
            }
        }
        return count;
    }

    @DbSwitch(value=DbRole.MASTER)
    public int alterRemarks(String remarks) {
        if (this.getSqlBeanDB().getDbType() == DbType.SQLite || this.getSqlBeanDB().getDbType() == DbType.Derby) {
            return 0;
        }
        String sql = SqlBeanProvider.alterRemarksSql((SqlBeanDB)this.getSqlBeanDB(), this.clazz, (String)remarks);
        return this.mybatisSqlBeanDao.executeSql(sql);
    }

    @DbSwitch(value=DbRole.MASTER)
    public List<String> getSchemas(String name) {
        if (this.getSqlBeanDB().getDbType() == DbType.SQLite) {
            return null;
        }
        return this.mybatisSqlBeanDao.databases(this.getSqlBeanDB(), name);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int createSchema(String name) {
        if (this.getSqlBeanDB().getDbType() == DbType.SQLite || this.getSqlBeanDB().getDbType() == DbType.Oracle) {
            return 0;
        }
        return this.mybatisSqlBeanDao.createSchema(this.getSqlBeanDB(), name);
    }

    @DbSwitch(value=DbRole.MASTER)
    public int dropSchema(String name) {
        if (this.getSqlBeanDB().getDbType() == DbType.SQLite || this.getSqlBeanDB().getDbType() == DbType.Oracle) {
            return 0;
        }
        return this.mybatisSqlBeanDao.dropSchema(this.getSqlBeanDB(), name);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropTable() {
        List<TableInfo> nameList;
        SqlBeanDB sqlBeanDB = this.getSqlBeanDB();
        if (sqlBeanDB.getDbType() != DbType.MySQL && sqlBeanDB.getDbType() != DbType.MariaDB && sqlBeanDB.getDbType() != DbType.Postgresql && sqlBeanDB.getDbType() != DbType.SQLServer && sqlBeanDB.getDbType() != DbType.H2 && ((nameList = this.mybatisSqlBeanDao.selectTableList(this.getSqlBeanDB(), SqlBeanUtil.getTable(this.clazz).getSchema(), SqlBeanUtil.getTable(this.clazz).getName())) == null || nameList.isEmpty())) {
            return;
        }
        this.mybatisSqlBeanDao.drop(sqlBeanDB, this.clazz);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void createTable() {
        this.mybatisSqlBeanDao.create(this.getSqlBeanDB(), this.clazz);
    }

    @DbSwitch(value=DbRole.MASTER)
    public void dropAndCreateTable() {
        this.dropTable();
        this.createTable();
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList() {
        return this.getTableList(SqlBeanUtil.getTable(this.clazz).getSchema(), null);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String tableName) {
        return this.getTableList(SqlBeanUtil.getTable(this.clazz).getSchema(), tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<TableInfo> getTableList(String schema, String tableName) {
        return this.mybatisSqlBeanDao.selectTableList(this.getSqlBeanDB(), schema, tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList() {
        Table table = SqlBeanUtil.getTable(this.clazz);
        return this.getColumnInfoList(table.getSchema(), table.getName());
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String tableName) {
        return this.getColumnInfoList(SqlBeanUtil.getTable(this.clazz).getSchema(), tableName);
    }

    @DbSwitch(value=DbRole.SLAVE)
    public List<ColumnInfo> getColumnInfoList(String schema, String tableName) {
        List<ColumnInfo> columnInfoList = this.mybatisSqlBeanDao.selectColumnInfoList(this.getSqlBeanDB(), schema, tableName);
        super.handleColumnInfo(columnInfoList);
        return columnInfoList;
    }
}

