/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.datasource;

import cn.vonce.sql.spring.annotation.DbTransactional;
import cn.vonce.sql.spring.datasource.ConnectionContextHolder;
import cn.vonce.sql.spring.datasource.TransactionalContextHolder;
import cn.vonce.sql.uitls.IdBuilder;
import cn.vonce.sql.uitls.StringUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TransactionalInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        DbTransactional dbTransactional = methodInvocation.getThis().getClass().getAnnotation(DbTransactional.class);
        if (methodInvocation.getMethod().isAnnotationPresent(DbTransactional.class)) {
            dbTransactional = methodInvocation.getMethod().getAnnotation(DbTransactional.class);
        }
        try {
            String xid = TransactionalContextHolder.getXid();
            if (StringUtil.isNotBlank((Object)xid)) {
                Object result2 = methodInvocation.proceed();
                return result2;
            }
            if (dbTransactional.readOnly()) {
                ConnectionContextHolder.setReadOnly(true);
            }
            TransactionalContextHolder.setXid(IdBuilder.uuid());
            result = methodInvocation.proceed();
            TransactionalContextHolder.clearXid();
            ConnectionContextHolder.commitOrRollback(true);
        }
        catch (Throwable e) {
            TransactionalContextHolder.clearXid();
            Class<? extends Throwable>[] rollbackFor = dbTransactional.rollbackFor();
            Class<? extends Throwable>[] noRollbackFor = dbTransactional.noRollbackFor();
            boolean needRollback = false;
            if (rollbackFor.length > 0) {
                for (Class<? extends Throwable> thr : rollbackFor) {
                    if (!thr.isAssignableFrom(e.getClass())) continue;
                    needRollback = true;
                    break;
                }
            }
            if (noRollbackFor.length > 0) {
                for (Class<? extends Throwable> thr : noRollbackFor) {
                    if (!thr.isAssignableFrom(e.getClass())) continue;
                    needRollback = false;
                    break;
                }
            }
            if (rollbackFor.length == 0 && noRollbackFor.length == 0) {
                needRollback = true;
            }
            ConnectionContextHolder.commitOrRollback(!needRollback);
            throw e;
        }
        return result;
    }
}

