/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.datasource;

import cn.vonce.sql.spring.datasource.ConnectionContextHolder;
import cn.vonce.sql.spring.datasource.ConnectionProxy;
import cn.vonce.sql.spring.datasource.DataSourceContextHolder;
import cn.vonce.sql.spring.datasource.TransactionalContextHolder;
import cn.vonce.sql.uitls.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    protected Object determineCurrentLookupKey() {
        return DataSourceContextHolder.getDataSource();
    }

    public Connection getConnection() throws SQLException {
        String xid = TransactionalContextHolder.getXid();
        String ds = DataSourceContextHolder.getDataSource();
        if (StringUtil.isEmpty((Object)xid)) {
            return this.determineTargetDataSource().getConnection();
        }
        return this.getConnectionProxy(ds, null, null);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String xid = TransactionalContextHolder.getXid();
        String ds = DataSourceContextHolder.getDataSource();
        if (StringUtil.isEmpty((Object)xid)) {
            return this.determineTargetDataSource().getConnection(username, password);
        }
        return this.getConnectionProxy(ds, username, password);
    }

    private ConnectionProxy getConnectionProxy(String ds, String username, String password) throws SQLException {
        ConnectionProxy connectionProxy;
        if (StringUtil.isBlank((Object)ds)) {
            ds = "default";
        }
        if ((connectionProxy = ConnectionContextHolder.getConnection(ds)) == null) {
            Connection connection = StringUtil.isBlank((Object)username) && StringUtil.isBlank((Object)password) ? this.determineTargetDataSource().getConnection() : this.determineTargetDataSource().getConnection(username, password);
            connectionProxy = new ConnectionProxy(ds, connection);
            ConnectionContextHolder.setConnection(ds, connectionProxy);
        }
        return connectionProxy;
    }
}

