/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.datasource;

import cn.vonce.sql.spring.annotation.DbSource;
import cn.vonce.sql.spring.annotation.DbSwitch;
import cn.vonce.sql.spring.datasource.DataSourceContextHolder;
import cn.vonce.sql.spring.datasource.TransactionalContextHolder;
import cn.vonce.sql.spring.enumerate.DbRole;
import cn.vonce.sql.uitls.StringUtil;
import java.lang.reflect.Method;
import java.util.Random;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Repository;

@Aspect
@Repository
public class DataSourceAspect {
    @Pointcut(value="target(cn.vonce.sql.service.SqlBeanService)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint joinPoint) {
        Class<?> clazz = joinPoint.getTarget().getClass();
        String xid = TransactionalContextHolder.getXid();
        if (clazz.isAnnotationPresent(DbSource.class) && StringUtil.isBlank((Object)xid)) {
            String methodName = joinPoint.getSignature().getName();
            Class[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getParameterTypes();
            String dataSource = null;
            DbSource dbSource = clazz.getAnnotation(DbSource.class);
            try {
                Method method = clazz.getMethod(methodName, parameterTypes);
                DbSwitch dbSwitch = method.getAnnotation(DbSwitch.class);
                dataSource = dbSwitch != null && dbSwitch.value() == DbRole.SLAVE && dbSource.slave().length > 0 ? (dbSource.slave().length == 1 ? dbSource.slave()[0] : dbSource.slave()[new Random().nextInt(dbSource.slave().length)]) : dbSource.master();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DataSourceContextHolder.setDataSource(dataSource);
        }
    }

    @After(value="pointcut()")
    public void after(JoinPoint joinPoint) {
        DataSourceContextHolder.clearDataSource();
    }
}

