/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.datasource;

import cn.vonce.sql.spring.datasource.ConnectionProxy;
import cn.vonce.sql.spring.datasource.DataSourceContextHolder;
import cn.vonce.sql.uitls.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionContextHolder {
    private static final ThreadLocal<ConcurrentHashMap<String, ConnectionProxy>> contextHolder = ThreadLocal.withInitial(() -> new ConcurrentHashMap());

    public static void setConnection(String ds, ConnectionProxy connectionProxy) {
        ConcurrentHashMap<String, ConnectionProxy> map = contextHolder.get();
        if (map != null) {
            try {
                connectionProxy.setAutoCommit(false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            map.put(ds, connectionProxy);
        }
    }

    public static ConnectionProxy getConnection(String ds) {
        return contextHolder.get().get(ds);
    }

    public static void commitOrRollback(boolean isOk) {
        String ds = DataSourceContextHolder.getDataSource();
        if (StringUtil.isBlank((Object)ds)) {
            ds = "default";
        }
        ConnectionContextHolder.commitOrRollback(ds, isOk);
    }

    public static void commitOrRollback(String ds, boolean isOk) {
        try {
            ConnectionProxy connectionProxy;
            ConcurrentHashMap<String, ConnectionProxy> map = contextHolder.get();
            if (map != null && (connectionProxy = map.get(ds)) != null) {
                if (isOk) {
                    connectionProxy.commit();
                } else {
                    connectionProxy.rollback();
                }
                connectionProxy.close();
                map.remove(ds);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void setReadOnly(boolean readOnly) {
        for (Map.Entry<String, ConnectionProxy> entry : contextHolder.get().entrySet()) {
            ConnectionContextHolder.setReadOnly(entry.getValue(), readOnly);
        }
    }

    public static void setReadOnly(String ds, boolean readOnly) {
        ConnectionContextHolder.setReadOnly(contextHolder.get().get(ds), readOnly);
    }

    public static void setReadOnly(ConnectionProxy connectionProxy, boolean readOnly) {
        try {
            connectionProxy.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

