/*
 * Decompiled with CFR 0.152.
 */
package cn.vonce.sql.spring.config;

import cn.vonce.sql.annotation.SqlTable;
import cn.vonce.sql.bean.Table;
import cn.vonce.sql.bean.TableInfo;
import cn.vonce.sql.config.SqlBeanConfig;
import cn.vonce.sql.enumerate.DbType;
import cn.vonce.sql.service.AdvancedDbManageService;
import cn.vonce.sql.service.DbManageService;
import cn.vonce.sql.service.SqlBeanService;
import cn.vonce.sql.uitls.SqlBeanUtil;
import cn.vonce.sql.uitls.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class AutoCreateTableListener
implements ApplicationListener<ContextRefreshedEvent> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private SqlBeanConfig sqlBeanConfig;
    private final Lock lock = new ReentrantLock();

    public void onApplicationEvent(ContextRefreshedEvent evt) {
        if (!(evt.getApplicationContext().getParent() != null && evt.getApplicationContext().getParent().getParent() != null || this.sqlBeanConfig != null && !this.sqlBeanConfig.getAutoCreate())) {
            this.lock.lock();
            try {
                new Thread(() -> this.processSqlBeanServices(evt)).start();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void processSqlBeanServices(ContextRefreshedEvent evt) {
        ArrayList<String> beanNameList = new ArrayList<String>();
        beanNameList.addAll(Arrays.asList(evt.getApplicationContext().getBeanNamesForType(SqlBeanService.class)));
        if (!beanNameList.isEmpty()) {
            HashMap<String, SqlBeanService> schemaMap = new HashMap<String, SqlBeanService>();
            for (String string : beanNameList) {
                SqlBeanService sqlBeanService = (SqlBeanService)evt.getApplicationContext().getBean(string, SqlBeanService.class);
                Class clazz = sqlBeanService.getBeanClass();
                if (clazz == null) continue;
                SqlTable sqlTable = SqlBeanUtil.getSqlTable((Class)clazz);
                schemaMap.put(sqlTable.schema(), sqlBeanService);
            }
            for (Map.Entry entry : schemaMap.entrySet()) {
                if (StringUtil.isNotBlank(entry.getKey())) {
                    if (((SqlBeanService)entry.getValue()).getSqlBeanDB().getDbType() == DbType.SQLite || ((SqlBeanService)entry.getValue()).getSqlBeanDB().getDbType() == DbType.Oracle) continue;
                    List databases = ((AdvancedDbManageService)entry.getValue()).getSchemas((String)entry.getKey());
                    if (databases == null || databases.isEmpty()) {
                        ((AdvancedDbManageService)entry.getValue()).createSchema((String)entry.getKey());
                        this.logger.info("-----Schema:[{}]\u4e0d\u5b58\u5728,\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", entry.getKey());
                    }
                }
                List tableList = ((DbManageService)entry.getValue()).getTableList();
                for (String name : beanNameList) {
                    SqlBeanService sqlBeanService = (SqlBeanService)evt.getApplicationContext().getBean(name, SqlBeanService.class);
                    Class clazz = sqlBeanService.getBeanClass();
                    if (clazz == null) continue;
                    SqlTable sqlTable = SqlBeanUtil.getSqlTable((Class)clazz);
                    Table table = SqlBeanUtil.getTable((Class)clazz);
                    if (sqlTable == null || sqlTable.isView() || !sqlTable.schema().equals(entry.getKey())) continue;
                    boolean isExist = false;
                    for (TableInfo tableInfo : tableList) {
                        if (!tableInfo.getName().equalsIgnoreCase(table.getName())) continue;
                        isExist = true;
                        if (!sqlTable.autoAlter() || sqlTable.remarks().equals(tableInfo.getRemarks())) break;
                        ((AdvancedDbManageService)sqlBeanService).alterRemarks(sqlTable.remarks());
                        break;
                    }
                    if (!isExist && sqlTable.autoCreate()) {
                        ((AdvancedDbManageService)sqlBeanService).createTable();
                        this.logger.info("-----Table:[{}]\u4e0d\u5b58\u5728,\u5df2\u4e3a\u4f60\u81ea\u52a8\u521b\u5efa-----", (Object)(StringUtil.isNotEmpty((Object)table.getSchema()) ? table.getSchema() + "." + table.getName() : table.getName()));
                        continue;
                    }
                    if (!isExist || !sqlTable.autoAlter()) continue;
                    try {
                        ((AdvancedDbManageService)sqlBeanService).alter(table, ((AdvancedDbManageService)sqlBeanService).getColumnInfoList(table.getName()));
                    }
                    catch (Exception e) {
                        this.logger.error("\u66f4\u65b0\u8868\u7ed3\u6784\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            schemaMap.clear();
        }
    }
}

