/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.web;

import com.thoughtworks.qdox.model.DocletTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.web.ClassAttributeComparator;
import org.xdoclet.plugin.web.ClassTagPredicate;
import org.xdoclet.plugin.web.WebUtils;
import org.xdoclet.plugin.web.qtags.TagLibrary;

public class WebPlugin
extends QDoxPlugin {
    public static final String PUBLIC_ID_2_2 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    public static final String SYSTEM_ID_2_2 = "http://java.sun.com/dtd/web-app_2_2.dtd";
    public static final String PUBLIC_ID_2_3 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    public static final String SYSTEM_ID_2_3 = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private String publicId = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    private String systemId = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static Map filterInterface = new HashMap();
    private static String servletInterface;
    private static String[] allWebInterfaces;
    private WebUtils webUtils;
    private String servletVersion = "2.3";
    protected String mergedir;

    public WebPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)jellyTemplateEngine, metadataProvider, writerMapper);
        this.setMultioutput(false);
        this.setFilereplace("web.xml");
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public String getServletVersion() {
        return this.servletVersion;
    }

    public void setServletVersion(String servletVersion) {
        this.servletVersion = servletVersion;
    }

    public WebUtils getWebUtils() throws ClassNotFoundException {
        if (this.webUtils == null) {
            this.webUtils = new WebUtils(this.servletVersion);
        }
        return this.webUtils;
    }

    public Collection getFilters() {
        ArrayList filters = new ArrayList();
        String[] interfaces = (String[])filterInterface.get(this.servletVersion);
        if (interfaces != null) {
            ClassTagPredicate predicate = new ClassTagPredicate(interfaces, "web.filter");
            CollectionUtils.select((Collection)this.metadataProvider.getMetadata(), (Predicate)predicate, filters);
            Collections.sort(filters, new ClassAttributeComparator("web.filter", "order"));
        }
        return filters;
    }

    public Collection getServlets() {
        ArrayList servlets = new ArrayList();
        ClassTagPredicate predicate = new ClassTagPredicate(servletInterface, "web.servlet");
        CollectionUtils.select((Collection)this.metadataProvider.getMetadata(), (Predicate)predicate, servlets);
        Collections.sort(servlets, new ClassAttributeComparator("web.servlet", "order"));
        return servlets;
    }

    public Collection getAllWebClasses() {
        ArrayList all = new ArrayList();
        ClassTagPredicate predicate = new ClassTagPredicate(allWebInterfaces);
        CollectionUtils.select((Collection)this.metadataProvider.getMetadata(), (Predicate)predicate, all);
        return this.metadataProvider.getMetadata();
    }

    public boolean needsServletRunAs(DocletTag tag) {
        return tag.getNamedParameter("run-as") != null && this.servletVersion.compareTo("2.3") >= 0;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getMergedir() {
        return this.mergedir;
    }

    public void setMergedir(String mergedir) {
        this.mergedir = mergedir;
    }

    static {
        filterInterface.put("2.3", new String[]{"javax.servlet.Filter"});
        filterInterface.put("2.4", new String[]{"javax.servlet.Filter"});
        servletInterface = "javax.servlet.Servlet";
        allWebInterfaces = new String[]{"javax.servlet.Filter", servletInterface, "javax.servlet.ServletContextAttributeListener", "javax.servlet.ServletContextListener", "javax.servlet.ServletRequestAttributeListener", "javax.servlet.ServletRequestListener", "javax.servlet.http.HttpSessionActivationListener", "javax.servlet.http.HttpSessionAttributeListener", "javax.servlet.http.HttpSessionBindingListener", "javax.servlet.http.HttpSessionListener"};
    }
}

