/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.web;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.web.ClassTagPredicate;
import org.xdoclet.plugin.web.WebUtils;
import org.xdoclet.plugin.web.qtags.TagLibrary;

public class TaglibPlugin
extends QDoxPlugin {
    public static final String PUBLIC_ID_1_2 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String SYSTEM_ID_1_2 = "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd";
    private static final String DEFAULT_TAGLIBVERSION = "1.0";
    private static final String DEFAULT_JSPVERSION = "1.2";
    private static final String DEFAULT_SHORTNAME = "taglib";
    private static final HashMap servletVersions = new HashMap();
    private static final HashMap publicIDs;
    private static final HashMap systemIDs;
    private static final HashMap tagInterfaces;
    private Collection allClasses;
    private WebUtils webUtils;
    private String jspversion;
    private String taglibversion;
    private String shortname;
    private String uri;
    private String displayname;
    private String smallicon;
    private String largeicon;
    private String description;
    private String validator;
    private boolean includeListeners = true;

    public TaglibPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)jellyTemplateEngine, metadataProvider, writerMapper);
        this.setMultioutput(false);
        this.setFilereplace("taglib.tld");
        this.setTaglibversion(DEFAULT_TAGLIBVERSION);
        this.setJspversion(DEFAULT_JSPVERSION);
        this.setShortname(DEFAULT_SHORTNAME);
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public boolean needsDoctype() {
        return this.getJspversion().startsWith("1.");
    }

    public Collection getTags() {
        ArrayList tags = new ArrayList();
        ClassTagPredicate predicate = new ClassTagPredicate((String[])tagInterfaces.get(this.getJspversion()), "jsp.tag");
        if (this.allClasses == null) {
            this.allClasses = this.metadataProvider.getMetadata();
        }
        CollectionUtils.select((Collection)this.allClasses, (Predicate)predicate, tags);
        return tags;
    }

    public Collection getAttributeMethods(JavaClass clazz) {
        ArrayList<JavaMethod> attributeMethods = new ArrayList<JavaMethod>();
        JavaMethod[] meths = clazz.getMethods();
        int i = 0;
        while (i < meths.length) {
            DocletTag tag = meths[i].getTagByName("jsp.attribute");
            if (tag != null) {
                attributeMethods.add(meths[i]);
            }
            ++i;
        }
        return attributeMethods;
    }

    public WebUtils getWebUtils() throws ClassNotFoundException {
        String servletVersion = (String)servletVersions.get(this.jspversion);
        if (this.webUtils == null) {
            this.webUtils = new WebUtils(servletVersion);
        }
        return this.webUtils;
    }

    public String getIncludelisteners() {
        return this.includeListeners ? "true" : "false";
    }

    public void setIncludelisteners(String includeListenersStr) {
        this.includeListeners = includeListenersStr.equalsIgnoreCase("true");
    }

    public String getJspversion() {
        return this.jspversion;
    }

    public void setJspversion(String jspversion) {
        this.jspversion = jspversion;
    }

    public String getTaglibversion() {
        return this.taglibversion;
    }

    public void setTaglibversion(String taglibversion) {
        this.taglibversion = taglibversion;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public String getSmallicon() {
        return this.smallicon;
    }

    public void setSmallicon(String smallicon) {
        this.smallicon = smallicon;
    }

    public String getLargeicon() {
        return this.largeicon;
    }

    public void setLargeicon(String largeicon) {
        this.largeicon = largeicon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    public String getPublicId() {
        return (String)publicIDs.get(this.getJspversion());
    }

    public String getSystemId() {
        return (String)systemIDs.get(this.getJspversion());
    }

    static {
        servletVersions.put("1.1", "2.2");
        servletVersions.put(DEFAULT_JSPVERSION, "2.3");
        servletVersions.put("2.0", "2.4");
        publicIDs = new HashMap();
        systemIDs = new HashMap();
        publicIDs.put("1.1", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        publicIDs.put(DEFAULT_JSPVERSION, PUBLIC_ID_1_2);
        systemIDs.put("1.1", "http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd");
        systemIDs.put(DEFAULT_JSPVERSION, SYSTEM_ID_1_2);
        tagInterfaces = new HashMap();
        tagInterfaces.put("1.1", new String[]{"javax.servlet.jsp.tagext.Tag"});
        tagInterfaces.put(DEFAULT_JSPVERSION, new String[]{"javax.servlet.jsp.tagext.Tag"});
        tagInterfaces.put("2.0", new String[]{"javax.servlet.jsp.tagext.Tag", "javax.servlet.jsp.tagext.JspTag"});
    }
}

