/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.tcpmon;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import org.apache.ws.commons.tcpmon.Listener;
import org.apache.ws.commons.tcpmon.SlowLinkSimulator;
import org.apache.ws.commons.tcpmon.SocketRR;
import org.apache.ws.commons.tcpmon.TCPMon;

class Connection
extends Thread {
    Listener listener;
    boolean active;
    String fromHost;
    String time;
    long elapsedTime;
    JTextArea inputText = null;
    JScrollPane inputScroll = null;
    JTextArea outputText = null;
    JScrollPane outputScroll = null;
    Socket inSocket = null;
    Socket outSocket = null;
    Thread clientThread = null;
    Thread serverThread = null;
    SocketRR rr1 = null;
    SocketRR rr2 = null;
    InputStream inputStream = null;
    String HTTPProxyHost = null;
    int HTTPProxyPort = 80;
    private SlowLinkSimulator slowLink;

    public Connection(Listener l) {
        this.listener = l;
        this.HTTPProxyHost = l.HTTPProxyHost;
        this.HTTPProxyPort = l.HTTPProxyPort;
        this.slowLink = l.slowLink;
    }

    public Connection(Listener l, Socket s) {
        this(l);
        this.inSocket = s;
        this.start();
    }

    public Connection(Listener l, InputStream in) {
        this(l);
        this.inputStream = in;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            byte[] b;
            this.active = true;
            this.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                this.HTTPProxyHost = null;
            }
            if (this.HTTPProxyHost != null) {
                String tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                this.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
            }
            this.fromHost = this.inSocket != null ? this.inSocket.getInetAddress().getHostName() : "resend";
            String dateformat = TCPMon.getMessage("dateformat00", "yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat df = new SimpleDateFormat(dateformat);
            this.time = df.format(new Date());
            int count = this.listener.connections.size();
            this.listener.tableModel.insertRow(count + 1, new Object[]{TCPMon.getMessage("active00", "Active"), this.time, this.fromHost, this.listener.hostField.getText(), ""});
            this.listener.connections.add(this);
            this.inputText = new JTextArea(null, null, 20, 80);
            this.inputScroll = new JScrollPane(this.inputText);
            this.outputText = new JTextArea(null, null, 20, 80);
            this.outputScroll = new JScrollPane(this.outputText);
            ListSelectionModel lsm = this.listener.connectionTable.getSelectionModel();
            if (count == 0 || lsm.getLeadSelectionIndex() == 0) {
                this.listener.outPane.setVisible(false);
                int divLoc = this.listener.outPane.getDividerLocation();
                this.listener.setLeft(this.inputScroll);
                this.listener.setRight(this.outputScroll);
                this.listener.removeButton.setEnabled(false);
                this.listener.removeAllButton.setEnabled(true);
                this.listener.saveButton.setEnabled(true);
                this.listener.resendButton.setEnabled(true);
                this.listener.outPane.setDividerLocation(divLoc);
                this.listener.outPane.setVisible(true);
            }
            String targetHost = this.listener.hostField.getText();
            int targetPort = Integer.parseInt(this.listener.tPortField.getText());
            int listenPort = Integer.parseInt(this.listener.portField.getText());
            InputStream tmpIn1 = this.inputStream;
            OutputStream tmpOut1 = null;
            InputStream tmpIn2 = null;
            OutputStream tmpOut2 = null;
            if (tmpIn1 == null) {
                tmpIn1 = this.inSocket.getInputStream();
            }
            if (this.inSocket != null) {
                tmpOut1 = this.inSocket.getOutputStream();
            }
            String bufferedData = null;
            StringBuffer buf = null;
            int index = this.listener.connections.indexOf(this);
            if (this.listener.isProxyBox.isSelected() || this.HTTPProxyHost != null) {
                int len;
                b = new byte[1];
                buf = new StringBuffer();
                while ((len = tmpIn1.read(b, 0, 1)) != -1) {
                    String s = new String(b);
                    buf.append(s);
                    if (b[0] != 10) continue;
                }
                bufferedData = buf.toString();
                this.inputText.append(bufferedData);
                if (bufferedData.startsWith("GET ") || bufferedData.startsWith("POST ") || bufferedData.startsWith("PUT ") || bufferedData.startsWith("DELETE ")) {
                    URL url;
                    int start = bufferedData.indexOf(32) + 1;
                    while (bufferedData.charAt(start) == ' ') {
                        ++start;
                    }
                    int end = bufferedData.indexOf(32, start);
                    String urlString = bufferedData.substring(start, end);
                    if (urlString.charAt(0) == '/') {
                        urlString = urlString.substring(1);
                    }
                    if (this.listener.isProxyBox.isSelected()) {
                        url = new URL(urlString);
                        targetHost = url.getHost();
                        targetPort = url.getPort();
                        if (targetPort == -1) {
                            targetPort = 80;
                        }
                        this.listener.tableModel.setValueAt(targetHost, index + 1, 3);
                        bufferedData = bufferedData.substring(0, start) + url.getFile() + bufferedData.substring(end);
                    } else {
                        url = new URL("http://" + targetHost + ":" + targetPort + "/" + urlString);
                        this.listener.tableModel.setValueAt(targetHost, index + 1, 3);
                        bufferedData = bufferedData.substring(0, start) + url.toExternalForm() + bufferedData.substring(end);
                        targetHost = this.HTTPProxyHost;
                        targetPort = this.HTTPProxyPort;
                    }
                }
            } else {
                String s1;
                int len;
                byte[] b1 = new byte[1];
                buf = new StringBuffer();
                String lastLine = null;
                while ((len = tmpIn1.read(b1, 0, 1)) != -1) {
                    s1 = new String(b1);
                    buf.append(s1);
                    if (b1[0] != 10) continue;
                    String line = buf.toString();
                    buf.setLength(0);
                    if (line.startsWith("Host: ")) {
                        String newHost = "Host: " + targetHost + ":" + listenPort + "\r\n";
                        bufferedData = bufferedData.concat(newHost);
                        break;
                    }
                    bufferedData = bufferedData == null ? line : bufferedData.concat(line);
                    if (line.equals("\r\n") || "\n".equals(lastLine) && line.equals("\n")) break;
                    lastLine = line;
                }
                if (bufferedData != null) {
                    this.inputText.append(bufferedData);
                    int idx = bufferedData.length() < 50 ? bufferedData.length() : 50;
                    s1 = bufferedData.substring(0, idx);
                    int i = s1.indexOf(10);
                    if (i > 0) {
                        s1 = s1.substring(0, i - 1);
                    }
                    s1 = s1 + "                           " + "                       ";
                    s1 = s1.substring(0, 51);
                    this.listener.tableModel.setValueAt(s1, index + 1, 4);
                }
            }
            if (targetPort == -1) {
                targetPort = 80;
            }
            this.outSocket = new Socket(targetHost, targetPort);
            tmpIn2 = this.outSocket.getInputStream();
            tmpOut2 = this.outSocket.getOutputStream();
            if (bufferedData != null) {
                b = bufferedData.getBytes();
                tmpOut2.write(b);
                this.slowLink.pump(b.length);
            }
            boolean format = this.listener.xmlFormatBox.isSelected();
            this.rr1 = new SocketRR(this, this.inSocket, tmpIn1, this.outSocket, tmpOut2, this.inputText, format, this.listener.tableModel, index + 1, "request:", this.slowLink);
            SlowLinkSimulator responseLink = new SlowLinkSimulator(this.slowLink);
            this.rr2 = new SocketRR(this, this.outSocket, tmpIn2, this.inSocket, tmpOut1, this.outputText, format, null, 0, "response:", responseLink);
            while (this.rr1 != null || this.rr2 != null) {
                if (this.rr2 != null) {
                    this.listener.tableModel.setValueAt(this.rr2.getElapsed(), 1 + index, 5);
                }
                if (null != this.rr1 && this.rr1.isDone()) {
                    if (index >= 0 && this.rr2 != null) {
                        this.listener.tableModel.setValueAt(TCPMon.getMessage("resp00", "Resp"), 1 + index, 0);
                    }
                    this.rr1 = null;
                }
                if (null != this.rr2 && this.rr2.isDone()) {
                    if (index >= 0 && this.rr1 != null) {
                        this.listener.tableModel.setValueAt(TCPMon.getMessage("req00", "Req"), 1 + index, 0);
                    }
                    this.rr2 = null;
                }
                Connection connection = this;
                synchronized (connection) {
                    this.wait(100L);
                }
            }
            this.active = false;
            if (index >= 0) {
                this.listener.tableModel.setValueAt(TCPMon.getMessage("done00", "Done"), 1 + index, 0);
            }
        }
        catch (Exception e) {
            StringWriter st = new StringWriter();
            PrintWriter wr = new PrintWriter(st);
            int index = this.listener.connections.indexOf(this);
            if (index >= 0) {
                this.listener.tableModel.setValueAt(TCPMon.getMessage("error00", "Error"), 1 + index, 0);
            }
            e.printStackTrace(wr);
            wr.close();
            if (this.outputText != null) {
                this.outputText.append(st.toString());
            } else {
                System.out.println(st.toString());
            }
            this.halt();
        }
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }

    public void halt() {
        try {
            if (this.rr1 != null) {
                this.rr1.halt();
            }
            if (this.rr2 != null) {
                this.rr2.halt();
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            this.inSocket = null;
            if (this.outSocket != null) {
                this.outSocket.close();
            }
            this.outSocket = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove() {
        int index = -1;
        try {
            this.halt();
            index = this.listener.connections.indexOf(this);
            this.listener.tableModel.removeRow(index + 1);
            this.listener.connections.remove(index);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

