/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.environment;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import tech.harmonysoft.oss.common.ProcessingResult;
import tech.harmonysoft.oss.environment.EnvironmentInfoProvider;
import tech.harmonysoft.oss.environment.TestContext;
import tech.harmonysoft.oss.environment.TestEnvironment;
import tech.harmonysoft.oss.json.JsonApi;
import tech.harmonysoft.oss.test.util.TestUtil;
import tech.harmonysoft.oss.test.util.VerificationUtil;

@Named
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J%\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\t\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\tH\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0007J#\u0010\u001b\u001a\u0002H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\t\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t \u0010*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ltech/harmonysoft/oss/environment/TestEnvironmentManager;", "", "json", "Ltech/harmonysoft/oss/json/JsonApi;", "logger", "Lorg/slf4j/Logger;", "environments", "Ljava/util/Optional;", "", "Ltech/harmonysoft/oss/environment/TestEnvironment;", "environmentInfoProvider", "Ltech/harmonysoft/oss/environment/EnvironmentInfoProvider;", "(Ltech/harmonysoft/oss/json/JsonApi;Lorg/slf4j/Logger;Ljava/util/Optional;Ljava/util/Optional;)V", "environmentConfigs", "Ljava/util/concurrent/ConcurrentHashMap;", "", "kotlin.jvm.PlatformType", "testContext", "Ltech/harmonysoft/oss/environment/TestContext;", "getEnvironmentConfigFile", "Ljava/io/File;", "environmentId", "getRunningEnvironmentConfig", "T", "environment", "(Ltech/harmonysoft/oss/environment/TestEnvironment;)Ljava/lang/Object;", "getSharedEnvironmentConfig", "startIfNecessary", "", "storeEnvironmentConfig", "config", "harmonysoft-test-environment"})
public final class TestEnvironmentManager {
    @NotNull
    private final JsonApi json;
    @NotNull
    private final Logger logger;
    private final Collection<TestEnvironment<?>> environments;
    @NotNull
    private final TestContext testContext;
    @NotNull
    private final ConcurrentHashMap<String, Object> environmentConfigs;

    /*
     * WARNING - void declaration
     */
    public TestEnvironmentManager(@NotNull JsonApi json, @NotNull Logger logger, @NotNull Optional<Collection<TestEnvironment<?>>> environments, @NotNull Optional<EnvironmentInfoProvider> environmentInfoProvider) {
        void $this$testContext_u24lambda_u2d0;
        File file;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(environments, (String)"environments");
        Intrinsics.checkNotNullParameter(environmentInfoProvider, (String)"environmentInfoProvider");
        this.json = json;
        this.logger = logger;
        this.environments = environments.orElse(CollectionsKt.emptyList());
        File file2 = file = Files.createTempDirectory("test", new FileAttribute[0]).toFile();
        TestEnvironmentManager testEnvironmentManager = this;
        boolean bl = false;
        $this$testContext_u24lambda_u2d0.deleteOnExit();
        File file3 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"createTempDirectory(\"tes\u2026.apply { deleteOnExit() }");
        String string = environmentInfoProvider.orElse(EnvironmentInfoProvider.Default.INSTANCE).getExecutionId();
        File file4 = file3;
        testEnvironmentManager.testContext = new TestContext(file4, string);
        this.environmentConfigs = new ConcurrentHashMap();
    }

    @BeforeEach
    public final void startIfNecessary() {
        for (TestEnvironment<?> environment : this.environments) {
            this.startIfNecessary(environment);
        }
    }

    @NotNull
    public final <T> T startIfNecessary(@NotNull TestEnvironment<T> environment) {
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        T t = this.getRunningEnvironmentConfig(environment);
        if (t != null) {
            T it = t;
            boolean bl = false;
            return it;
        }
        this.logger.info("starting '{}' test environment", (Object)environment.getId());
        T config = environment.start(this.testContext);
        this.logger.info("started '{}' environment verifying if it looks good, config: {}", (Object)environment.getId(), config);
        VerificationUtil.verifyConditionHappens$default((VerificationUtil)VerificationUtil.INSTANCE, null, (long)0L, (long)0L, (Function0)((Function0)new Function0<ProcessingResult<Unit, String>>(environment, config){
            final /* synthetic */ TestEnvironment<T> $environment;
            final /* synthetic */ T $config;
            {
                this.$environment = $environment;
                this.$config = $config;
                super(0);
            }

            @NotNull
            public final ProcessingResult<Unit, String> invoke() {
                return this.$environment.isRunning(this.$config) ? ProcessingResult.Companion.success() : ProcessingResult.Companion.failure((Object)("newly started '" + this.$environment.getId() + "' environment is not actually running, config: " + this.$config));
            }
        }), (int)7, null);
        this.storeEnvironmentConfig(environment.getId(), config);
        return config;
    }

    @Nullable
    public final <T> T getRunningEnvironmentConfig(@NotNull TestEnvironment<T> environment) {
        Object v0;
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Object object = this.environmentConfigs.get(environment.getId());
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return (T)it;
        }
        T config = this.getSharedEnvironmentConfig(environment);
        if (config == null) {
            this.logger.info("no pre-stored config is found for environment {}", (Object)environment.getId());
            v0 = null;
        } else {
            this.logger.info("found shared config for '{}' environment, checking if it is running ({})", (Object)environment.getId(), config);
            if (environment.isRunning(config)) {
                this.logger.info("detected that '{}' environment is available for config {}", (Object)environment.getId(), config);
                ((Map)this.environmentConfigs).put(environment.getId(), config);
                v0 = config;
            } else {
                this.logger.info("detected that '{}' environment is not available for config {}", (Object)environment.getId(), config);
                v0 = null;
            }
        }
        return v0;
    }

    private final <T> T getSharedEnvironmentConfig(TestEnvironment<T> environment) {
        Object object;
        File envConfigFile = this.getEnvironmentConfigFile(environment.getId());
        if (!envConfigFile.isFile()) {
            return null;
        }
        try {
            object = this.json.parse(FilesKt.readText$default((File)envConfigFile, null, (int)1, null), environment.getConfigClass());
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{environment.getId(), envConfigFile.getCanonicalPath(), FilesKt.readText$default((File)envConfigFile, null, (int)1, null)};
            this.logger.warn("can not deserialize {} environment config from file {} data:\n{}", objectArray);
            object = null;
        }
        return (T)object;
    }

    private final void storeEnvironmentConfig(String environmentId, Object config) {
        boolean created;
        ((Map)this.environmentConfigs).put(environmentId, config);
        File configFile = this.getEnvironmentConfigFile(environmentId);
        if (!configFile.getParentFile().isDirectory() && !(created = configFile.getParentFile().mkdirs())) {
            TestUtil.INSTANCE.fail("can not create directory for storing '" + environmentId + "' environment config (" + configFile.getParentFile().getCanonicalPath() + ')');
            throw new KotlinNothingValueException();
        }
        FilesKt.writeText$default((File)configFile, (String)this.json.writeJson(config), null, (int)2, null);
        Object[] objectArray = new Object[]{environmentId, configFile.getCanonicalPath(), FilesKt.readText$default((File)configFile, null, (int)1, null)};
        this.logger.info("stored '{}' environment config into {}:\n{}", objectArray);
    }

    private final File getEnvironmentConfigFile(String environmentId) {
        File userHomeDir = new File(System.getProperty("user.home"));
        File rootConfigDir = new File(userHomeDir, ".test-environment");
        File rootExecutionDir = new File(rootConfigDir, this.testContext.getExecutionId());
        File envConfigDir = new File(rootExecutionDir, environmentId);
        return new File(envConfigDir, environmentId + "-config.json");
    }
}

