/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.cucumber.glue;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.After;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.mongo.service.TestMongoManager;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltech/harmonysoft/oss/cucumber/glue/MongoStepDefinitions;", "", "()V", "mongo", "Ltech/harmonysoft/oss/mongo/service/TestMongoManager;", "cleanUpData", "", "ensureDocumentsExist", "collection", "", "data", "Lio/cucumber/datatable/DataTable;", "ensureJsonDocumentExists", "verifyDocumentsExist", "collectionName", "verifyJsonDocumentExists", "json", "harmonysoft-mongo-cucumber"})
public final class MongoStepDefinitions {
    @Inject
    private TestMongoManager mongo;

    @After
    public final void cleanUpData() {
        TestMongoManager testMongoManager = this.mongo;
        if (testMongoManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongo");
            testMongoManager = null;
        }
        testMongoManager.cleanUpData();
    }

    @Given(value="^mongo ([^\\s]+) collection has the following documents?:$")
    public final void ensureDocumentsExist(@NotNull String collection, @NotNull DataTable data) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TestMongoManager testMongoManager = this.mongo;
        if (testMongoManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongo");
            testMongoManager = null;
        }
        List list = data.asMaps();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"data.asMaps()");
        testMongoManager.ensureDocumentsExist(collection, (Collection)list);
    }

    @Given(value="^mongo ([^\\s]+) collection has the following JSON document:$")
    public final void ensureJsonDocumentExists(@NotNull String collection, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TestMongoManager testMongoManager = this.mongo;
        if (testMongoManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongo");
            testMongoManager = null;
        }
        testMongoManager.ensureJsonDocumentExist(collection, data);
    }

    @Then(value="^mongo ([^\\s]+) collection should have the following documents?:$")
    public final void verifyDocumentsExist(@NotNull String collectionName, @NotNull DataTable data) {
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        TestMongoManager testMongoManager = this.mongo;
        if (testMongoManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongo");
            testMongoManager = null;
        }
        List list = data.asMaps();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"data.asMaps()");
        testMongoManager.verifyDocumentsExist(collectionName, list);
    }

    @Then(value="^mongo ([^\\s]+) collection should have a document with at least the following data:$")
    public final void verifyJsonDocumentExists(@NotNull String collectionName, @NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        TestMongoManager testMongoManager = this.mongo;
        if (testMongoManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mongo");
            testMongoManager = null;
        }
        testMongoManager.verifyJsonDocumentExists(collectionName, json);
    }
}

