/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.cucumber.glue;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.After;
import io.cucumber.java.en.Given;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import tech.harmonysoft.oss.common.auth.model.Credential;
import tech.harmonysoft.oss.common.data.DataProviderStrategy;
import tech.harmonysoft.oss.mongo.config.TestMongoConfig;
import tech.harmonysoft.oss.mongo.config.TestMongoConfigProvider;
import tech.harmonysoft.oss.mongo.constant.Mongo;
import tech.harmonysoft.oss.test.util.VerificationUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\"\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0016J\"\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00010\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltech/harmonysoft/oss/cucumber/glue/MongoStepDefinitions;", "", "()V", "allDocumentsFilter", "Lcom/mongodb/BasicDBObject;", "client", "Lcom/mongodb/client/MongoClient;", "getClient", "()Lcom/mongodb/client/MongoClient;", "client$delegate", "Lkotlin/Lazy;", "configProvider", "Ltech/harmonysoft/oss/mongo/config/TestMongoConfigProvider;", "logger", "Lorg/slf4j/Logger;", "cleanUpData", "", "ensureDocumentExists", "collection", "", "data", "Lio/cucumber/datatable/DataTable;", "", "verifyDocumentExists", "collectionName", "verifyDocumentsExist", "harmonysoft-mongo-cucumber"})
public final class MongoStepDefinitions {
    @NotNull
    private final BasicDBObject allDocumentsFilter = new BasicDBObject();
    @Inject
    private TestMongoConfigProvider configProvider;
    @Inject
    private Logger logger;
    @NotNull
    private final Lazy client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MongoClient>(this){
        final /* synthetic */ MongoStepDefinitions this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final MongoClient invoke() {
            Object object;
            TestMongoConfig config;
            block5: {
                block4: {
                    TestMongoConfigProvider testMongoConfigProvider = MongoStepDefinitions.access$getConfigProvider$p(this.this$0);
                    if (testMongoConfigProvider == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"configProvider");
                        testMongoConfigProvider = null;
                    }
                    Object object2 = testMongoConfigProvider.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"configProvider.data");
                    config = (TestMongoConfig)object2;
                    object = config.getCredential();
                    if (object == null) break block4;
                    Credential it = object;
                    boolean bl = false;
                    String string = it.getLogin() + ':' + it.getPassword() + '@';
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            Object auth = object;
            return MongoClients.create((String)("mongodb://" + (String)auth + config.getHost() + ':' + config.getPort() + '/' + config.getDb()));
        }
    }));

    private final MongoClient getClient() {
        Lazy lazy = this.client$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-client>(...)");
        return (MongoClient)object;
    }

    @After
    public final void cleanUpData() {
        MongoClient mongoClient = this.getClient();
        TestMongoConfigProvider testMongoConfigProvider = this.configProvider;
        if (testMongoConfigProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configProvider");
            testMongoConfigProvider = null;
        }
        MongoDatabase db = mongoClient.getDatabase(((TestMongoConfig)testMongoConfigProvider.getData()).getDb());
        for (String collectionName : db.listCollectionNames()) {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                logger = null;
            }
            logger.info("Deleting all documents from mongo collection {}", (Object)collectionName);
            DeleteResult result = db.getCollection(collectionName).deleteMany((Bson)this.allDocumentsFilter);
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                logger2 = null;
            }
            logger2.info("Deleted {} document(s) in mongo collection {}", (Object)result.getDeletedCount(), (Object)collectionName);
        }
    }

    @Given(value="^mongo ([^\\s]+) collection has the following documents?$")
    public final void ensureDocumentExists(@NotNull String collection, @NotNull DataTable data) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        for (Map documentData : data.asMaps()) {
            Intrinsics.checkNotNullExpressionValue((Object)documentData, (String)"documentData");
            this.ensureDocumentExists(collection, documentData);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureDocumentExists(@NotNull String collection, @NotNull Map<String, ? extends Object> data) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Map<String, ? extends Object> $this$map$iv = data;
        boolean $i$f$map = false;
        Map<String, ? extends Object> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(Filters.eq((String)((String)it.getKey()), it.getValue()));
        }
        Bson filter = Filters.and((Iterable)((List)destination$iv$iv));
        MongoClient mongoClient = this.getClient();
        TestMongoConfigProvider testMongoConfigProvider = this.configProvider;
        if (testMongoConfigProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configProvider");
            testMongoConfigProvider = null;
        }
        mongoClient.getDatabase(((TestMongoConfig)testMongoConfigProvider.getData()).getDb()).getCollection(collection).updateOne(filter, Updates.set((String)"dummy", (Object)"dummy"), new UpdateOptions().upsert(true));
    }

    @Given(value="^mongo ([^\\s]+) collection should have the following documents?$")
    public final void verifyDocumentsExist(@NotNull String collection, @NotNull DataTable data) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        for (Map expected : data.asMaps()) {
            Intrinsics.checkNotNullExpressionValue((Object)expected, (String)"expected");
            this.verifyDocumentExists(collection, expected);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void verifyDocumentExists(@NotNull String collectionName, @NotNull Map<String, ? extends Object> data) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)collectionName, (String)"collectionName");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        MongoClient mongoClient = this.getClient();
        TestMongoConfigProvider testMongoConfigProvider = this.configProvider;
        if (testMongoConfigProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configProvider");
            testMongoConfigProvider = null;
        }
        MongoCollection collection = mongoClient.getDatabase(((TestMongoConfig)testMongoConfigProvider.getData()).getDb()).getCollection(collectionName);
        FindIterable findIterable = collection.find((Bson)Mongo.Filter.INSTANCE.getALL()).projection(Projections.include((List)CollectionsKt.toList((Iterable)data.keySet())));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"collection\n            .\u2026lude(data.keys.toList()))");
        Iterable iterable = CollectionsKt.toList((Iterable)((Iterable)findIterable));
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Document document = (Document)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(MapsKt.toMap((Map)((Map)it)));
        }
        List documents = (List)destination$iv$iv;
        VerificationUtil.verifyContains$default((VerificationUtil)VerificationUtil.INSTANCE, data, (Collection)documents, data.keySet(), (DataProviderStrategy)DataProviderStrategy.Companion.fromMap(), null, (int)16, null);
    }

    public static final /* synthetic */ TestMongoConfigProvider access$getConfigProvider$p(MongoStepDefinitions $this) {
        return $this.configProvider;
    }
}

