/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.cucumber.glue;

import io.cucumber.java.After;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.kafka.service.TestKafkaManager;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0007J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/harmonysoft/oss/cucumber/glue/KafkaStepDefinitions;", "", "()V", "kafka", "Ltech/harmonysoft/oss/kafka/service/TestKafkaManager;", "createTopicIfNecessary", "", "name", "", "sendMessage", "topic", "message", "subscribe", "tearDown", "verifyJsonMessageIsReceived", "expectedJson", "verifyMessageIsReceived", "expected", "verifyNoJsonMessageIsReceived", "verifyNoMessageIsReceived", "harmonysoft-kafka-cucumber"})
public final class KafkaStepDefinitions {
    @Inject
    private TestKafkaManager kafka;

    @After
    public final void tearDown() {
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.clean();
    }

    @Given(value="^kafka topic '$([^']+)' exists$")
    public final void createTopicIfNecessary(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.ensureTopicExists(name);
    }

    @Given(value="^kafka topic '([^']+)' is subscribed$")
    public final void subscribe(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.subscribe(topic);
    }

    @Given(value="^the following kafka message is sent to topic '([^']+)':$")
    public final void sendMessage(@NotNull String topic, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.sendMessage(topic, message);
    }

    @Then(value="^the following message is received in kafka topic '([^']+)':$")
    public final void verifyMessageIsReceived(@NotNull String topic, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.verifyMessageIsReceived(expected, topic);
    }

    @Then(value="^the following JSON message is received in kafka topic '([^']+)':$")
    public final void verifyJsonMessageIsReceived(@NotNull String topic, @NotNull String expectedJson) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)expectedJson, (String)"expectedJson");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.verifyJsonMessageIsReceived(expectedJson, topic);
    }

    @Then(value="^the following message is not received in kafka topic '([^']+)':$")
    public final void verifyNoMessageIsReceived(@NotNull String topic, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.verifyMessageIsNotReceived(expected, topic);
    }

    @Then(value="^the following JSON message is not received in kafka topic '([^']+)':$")
    public final void verifyNoJsonMessageIsReceived(@NotNull String topic, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        TestKafkaManager testKafkaManager = this.kafka;
        if (testKafkaManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kafka");
            testKafkaManager = null;
        }
        testKafkaManager.verifyJsonMessageIsNotReceived(expected, topic);
    }
}

