/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.http.client;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Priority;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.harmonysoft.oss.http.client.HttpClient;
import tech.harmonysoft.oss.http.client.impl.HttpClientImpl;
import tech.harmonysoft.oss.http.client.response.HttpResponse;
import tech.harmonysoft.oss.http.client.response.HttpResponseConverter;
import tech.harmonysoft.oss.test.TestAware;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Priority(value=10000)
@Named
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J>\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J \u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\rH\u0016J$\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/harmonysoft/oss/http/client/TestHttpClient;", "Ltech/harmonysoft/oss/http/client/HttpClient;", "Ltech/harmonysoft/oss/test/TestAware;", "delegate", "Ltech/harmonysoft/oss/http/client/impl/HttpClientImpl;", "(Ltech/harmonysoft/oss/http/client/impl/HttpClientImpl;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "stubResponses", "Ljava/util/concurrent/LinkedBlockingQueue;", "Ltech/harmonysoft/oss/http/client/TestHttpClient$ResponseStub;", "close", "", "execute", "Ltech/harmonysoft/oss/http/client/response/HttpResponse;", "T", "request", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;", "converter", "Ltech/harmonysoft/oss/http/client/response/HttpResponseConverter;", "headers", "", "", "maybeFindStubResponse", "", "method", "url", "onTestEnd", "stubResponse", "urlPattern", "Lkotlin/text/Regex;", "response", "ResponseStub", "harmonysoft-http-client-apache-test"})
public final class TestHttpClient
implements HttpClient,
TestAware {
    @NotNull
    private final HttpClientImpl delegate;
    private final Logger logger;
    @NotNull
    private final LinkedBlockingQueue<ResponseStub> stubResponses;

    public TestHttpClient(@NotNull HttpClientImpl delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.logger = LoggerFactory.getLogger(TestHttpClient.class);
        this.stubResponses = new LinkedBlockingQueue();
    }

    public void onTestEnd() {
        this.stubResponses.clear();
    }

    public final void stubResponse(@NotNull String method, @NotNull Regex urlPattern, @NotNull HttpResponse<byte[]> response) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)urlPattern, (String)"urlPattern");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        this.stubResponses.removeIf(arg_0 -> TestHttpClient.stubResponse$lambda-0(method, urlPattern, arg_0));
        ((Collection)this.stubResponses).add(new ResponseStub(method, urlPattern, response));
    }

    private final HttpResponse<byte[]> maybeFindStubResponse(String method, String url) {
        HttpResponse httpResponse;
        HttpResponse httpResponse2;
        Object v0;
        block3: {
            Iterable iterable = this.stubResponses;
            for (Object t : iterable) {
                ResponseStub stub = (ResponseStub)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)stub.getMethod(), (Object)method) && stub.getUrlPattern().matches((CharSequence)url))) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ResponseStub responseStub = v0;
        if (responseStub != null && (httpResponse2 = responseStub.getResponse()) != null) {
            httpResponse = httpResponse2;
        } else {
            TestHttpClient $this$maybeFindStubResponse_u24lambda_u2d2 = this;
            boolean bl = false;
            $this$maybeFindStubResponse_u24lambda_u2d2.logger.info("No stub response is detected for {} request to {}, performing a real HTTP call", (Object)method, (Object)url);
            httpResponse = null;
        }
        return httpResponse;
    }

    @NotNull
    public <T> HttpResponse<T> execute(@NotNull HttpUriRequestBase request, @NotNull HttpResponseConverter<T> converter, @NotNull Map<String, String> headers) {
        HttpResponse httpResponse;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(converter, (String)"converter");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                String string = request.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.method");
                String string2 = request.getRequestUri();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.requestUri");
                httpResponse = this.maybeFindStubResponse(string, string2);
                if (httpResponse == null) break block2;
                HttpResponse it = httpResponse;
                boolean bl = false;
                HttpResponse httpResponse2 = it.withBody(converter.convert((byte[])it.getBody(), Charsets.UTF_8));
                httpResponse = httpResponse2;
                if (httpResponse2 != null) break block3;
            }
            httpResponse = this.delegate.execute(request, converter, headers);
        }
        return httpResponse;
    }

    public void close() {
    }

    @NotNull
    public <T> HttpResponse<T> delete(@NotNull String url, @NotNull HttpResponseConverter<T> converter, @NotNull Map<String, String> headers) {
        return HttpClient.DefaultImpls.delete((HttpClient)this, (String)url, converter, headers);
    }

    @NotNull
    public HttpResponse<String> get(@NotNull String url, @NotNull Map<String, String> headers) {
        return HttpClient.DefaultImpls.get((HttpClient)this, (String)url, headers);
    }

    @NotNull
    public <T> HttpResponse<T> get(@NotNull String url, @NotNull HttpResponseConverter<T> converter, @NotNull Map<String, String> headers) {
        return HttpClient.DefaultImpls.get((HttpClient)this, (String)url, converter, headers);
    }

    @NotNull
    public <T> HttpResponse<T> post(@NotNull String url, @NotNull HttpEntity entity, @NotNull HttpResponseConverter<T> converter, @NotNull Map<String, String> headers) {
        return HttpClient.DefaultImpls.post((HttpClient)this, (String)url, (HttpEntity)entity, converter, headers);
    }

    @NotNull
    public <T> HttpResponse<T> put(@NotNull String url, @NotNull HttpEntity entity, @NotNull HttpResponseConverter<T> converter, @NotNull Map<String, String> headers) {
        return HttpClient.DefaultImpls.put((HttpClient)this, (String)url, (HttpEntity)entity, converter, headers);
    }

    public void onTestStart() {
        TestAware.DefaultImpls.onTestStart((TestAware)this);
    }

    private static final boolean stubResponse$lambda-0(String $method, Regex $urlPattern, ResponseStub it) {
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$urlPattern, (String)"$urlPattern");
        return Intrinsics.areEqual((Object)it.getMethod(), (Object)$method) && Intrinsics.areEqual((Object)it.getUrlPattern().toString(), (Object)$urlPattern.toString());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ltech/harmonysoft/oss/http/client/TestHttpClient$ResponseStub;", "", "method", "", "urlPattern", "Lkotlin/text/Regex;", "response", "Ltech/harmonysoft/oss/http/client/response/HttpResponse;", "", "(Ljava/lang/String;Lkotlin/text/Regex;Ltech/harmonysoft/oss/http/client/response/HttpResponse;)V", "getMethod", "()Ljava/lang/String;", "getResponse", "()Ltech/harmonysoft/oss/http/client/response/HttpResponse;", "getUrlPattern", "()Lkotlin/text/Regex;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "harmonysoft-http-client-apache-test"})
    private static final class ResponseStub {
        @NotNull
        private final String method;
        @NotNull
        private final Regex urlPattern;
        @NotNull
        private final HttpResponse<byte[]> response;

        public ResponseStub(@NotNull String method, @NotNull Regex urlPattern, @NotNull HttpResponse<byte[]> response) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)urlPattern, (String)"urlPattern");
            Intrinsics.checkNotNullParameter(response, (String)"response");
            this.method = method;
            this.urlPattern = urlPattern;
            this.response = response;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final Regex getUrlPattern() {
            return this.urlPattern;
        }

        @NotNull
        public final HttpResponse<byte[]> getResponse() {
            return this.response;
        }

        @NotNull
        public final String component1() {
            return this.method;
        }

        @NotNull
        public final Regex component2() {
            return this.urlPattern;
        }

        @NotNull
        public final HttpResponse<byte[]> component3() {
            return this.response;
        }

        @NotNull
        public final ResponseStub copy(@NotNull String method, @NotNull Regex urlPattern, @NotNull HttpResponse<byte[]> response) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)urlPattern, (String)"urlPattern");
            Intrinsics.checkNotNullParameter(response, (String)"response");
            return new ResponseStub(method, urlPattern, response);
        }

        public static /* synthetic */ ResponseStub copy$default(ResponseStub responseStub, String string, Regex regex, HttpResponse httpResponse, int n, Object object) {
            if ((n & 1) != 0) {
                string = responseStub.method;
            }
            if ((n & 2) != 0) {
                regex = responseStub.urlPattern;
            }
            if ((n & 4) != 0) {
                httpResponse = responseStub.response;
            }
            return responseStub.copy(string, regex, httpResponse);
        }

        @NotNull
        public String toString() {
            return "ResponseStub(method=" + this.method + ", urlPattern=" + this.urlPattern + ", response=" + this.response + ')';
        }

        public int hashCode() {
            int result = this.method.hashCode();
            result = result * 31 + this.urlPattern.hashCode();
            result = result * 31 + this.response.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResponseStub)) {
                return false;
            }
            ResponseStub responseStub = (ResponseStub)other;
            if (!Intrinsics.areEqual((Object)this.method, (Object)responseStub.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.urlPattern, (Object)responseStub.urlPattern)) {
                return false;
            }
            return Intrinsics.areEqual(this.response, responseStub.response);
        }
    }
}

