/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.util;

import jakarta.inject.Named;
import java.time.Clock;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltech/harmonysoft/oss/common/time/util/TimeSpecHelper;", "", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "(Ltech/harmonysoft/oss/common/time/clock/ClockProvider;)V", "getTime", "Ljava/time/ZonedDateTime;", "timeSpec", "", "maybeGetTime", "TimePattern", "harmonysoft-common"})
@SourceDebugExtension(value={"SMAP\nTimeSpecHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeSpecHelper.kt\ntech/harmonysoft/oss/common/time/util/TimeSpecHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class TimeSpecHelper {
    @NotNull
    private final ClockProvider clockProvider;

    public TimeSpecHelper(@NotNull ClockProvider clockProvider) {
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        this.clockProvider = clockProvider;
    }

    @NotNull
    public final ZonedDateTime getTime(@NotNull String timeSpec) {
        Intrinsics.checkNotNullParameter((Object)timeSpec, (String)"timeSpec");
        ZonedDateTime zonedDateTime = this.maybeGetTime(timeSpec);
        if (zonedDateTime == null) {
            throw new IllegalArgumentException("can't parse time spec '" + timeSpec + "'");
        }
        return zonedDateTime;
    }

    @Nullable
    public final ZonedDateTime maybeGetTime(@NotNull String timeSpec) {
        Object object;
        block7: {
            ZonedDateTime now;
            block6: {
                Intrinsics.checkNotNullParameter((Object)timeSpec, (String)"timeSpec");
                now = ZonedDateTime.now((Clock)this.clockProvider.getData());
                if (Intrinsics.areEqual((Object)timeSpec, (Object)"T")) {
                    return now;
                }
                object = TimePattern.INSTANCE.getT_MINUS().matchEntire((CharSequence)timeSpec);
                if (object == null) break block6;
                MatchResult it = object;
                boolean bl = false;
                ZonedDateTime zonedDateTime = now.minusDays(Long.parseLong((String)it.getGroupValues().get(1)));
                object = zonedDateTime;
                if (zonedDateTime != null) break block7;
            }
            MatchResult matchResult = TimePattern.INSTANCE.getT_PLUS().matchEntire((CharSequence)timeSpec);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl = false;
                object = now.plusDays(Long.parseLong((String)it.getGroupValues().get(1)));
            } else {
                object = null;
            }
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ltech/harmonysoft/oss/common/time/util/TimeSpecHelper$TimePattern;", "", "()V", "T_MINUS", "Lkotlin/text/Regex;", "getT_MINUS", "()Lkotlin/text/Regex;", "T_PLUS", "getT_PLUS", "harmonysoft-common"})
    public static final class TimePattern {
        @NotNull
        public static final TimePattern INSTANCE = new TimePattern();
        @NotNull
        private static final Regex T_MINUS = new Regex("T\\s*-\\s*(\\d+)");
        @NotNull
        private static final Regex T_PLUS = new Regex("T\\s*\\+\\s*(\\d+)");

        private TimePattern() {
        }

        @NotNull
        public final Regex getT_MINUS() {
            return T_MINUS;
        }

        @NotNull
        public final Regex getT_PLUS() {
            return T_PLUS;
        }
    }
}

