/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.schedule.impl;

import java.time.DayOfWeek;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.time.schedule.impl.TimeWindow;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c2\u0003J)\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/DaysOfWeekTimeWindows;", "", "daysOfWeek", "", "Ljava/time/DayOfWeek;", "_timeWindows", "Ltech/harmonysoft/oss/common/time/schedule/impl/TimeWindow;", "(Ljava/util/Set;Ljava/util/Set;)V", "getDaysOfWeek", "()Ljava/util/Set;", "timeWindows", "", "getTimeWindows", "()[Ltech/harmonysoft/oss/common/time/schedule/impl/TimeWindow;", "[Ltech/harmonysoft/oss/common/time/schedule/impl/TimeWindow;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "timeMsUntilTargetTimeIntervalEnd", "", "dayTimeOffsetMillis", "timeMsUntilTargetTimeIntervalStart", "dayTimeOffestMillis", "toString", "", "harmonysoft-common"})
public final class DaysOfWeekTimeWindows {
    @NotNull
    private final Set<DayOfWeek> daysOfWeek;
    @NotNull
    private final Set<TimeWindow> _timeWindows;
    @NotNull
    private final TimeWindow[] timeWindows;

    public DaysOfWeekTimeWindows(@NotNull Set<? extends DayOfWeek> daysOfWeek, @NotNull Set<TimeWindow> _timeWindows) {
        Intrinsics.checkNotNullParameter(daysOfWeek, (String)"daysOfWeek");
        Intrinsics.checkNotNullParameter(_timeWindows, (String)"_timeWindows");
        this.daysOfWeek = daysOfWeek;
        this._timeWindows = _timeWindows;
        Collection $this$toTypedArray$iv = this._timeWindows;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TimeWindow[] timeWindowArray = thisCollection$iv.toArray(new TimeWindow[0]);
        Intrinsics.checkNotNull((Object)timeWindowArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        this.timeWindows = timeWindowArray;
        for (TimeWindow timeWindow : this.timeWindows) {
            TimeWindow timeWindow2;
            block2: {
                TimeWindow timeWindow3;
                TimeWindow[] timeWindowArray2 = this.timeWindows;
                int n = timeWindowArray2.length;
                for (int i = 0; i < n; ++i) {
                    TimeWindow timeWindow4;
                    TimeWindow it = timeWindow4 = timeWindowArray2[i];
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)timeWindow) && it.overlaps(timeWindow))) continue;
                    timeWindow3 = timeWindow4;
                    break block2;
                }
                timeWindow3 = timeWindow2 = null;
            }
            if (timeWindow2 == null) continue;
            TimeWindow overlappingTimeWindow = timeWindow2;
            boolean bl = false;
            throw new IllegalArgumentException("detected overlapping time windows: '" + timeWindow + "' and '" + overlappingTimeWindow + "' in " + this);
        }
    }

    @NotNull
    public final Set<DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @NotNull
    public final TimeWindow[] getTimeWindows() {
        return this.timeWindows;
    }

    public final long timeMsUntilTargetTimeIntervalEnd(long dayTimeOffsetMillis) {
        long l;
        TimeWindow timeWindow;
        block3: {
            TimeWindow timeWindow2;
            TimeWindow[] timeWindowArray = this.timeWindows;
            int n = timeWindowArray.length;
            for (int i = 0; i < n; ++i) {
                TimeWindow timeWindow3;
                TimeWindow it = timeWindow3 = timeWindowArray[i];
                boolean bl = false;
                if (!it.inWindow(dayTimeOffsetMillis)) continue;
                timeWindow2 = timeWindow3;
                break block3;
            }
            timeWindow2 = timeWindow = null;
        }
        if (timeWindow != null) {
            TimeWindow it = timeWindow;
            boolean bl = false;
            l = it.getEndTimeDayOffsetMillis() - dayTimeOffsetMillis;
        } else {
            l = -1L;
        }
        return l;
    }

    public final long timeMsUntilTargetTimeIntervalStart(long dayTimeOffestMillis) {
        long result = -1L;
        for (TimeWindow timeWindow : this.timeWindows) {
            if (timeWindow.inWindow(dayTimeOffestMillis)) {
                return 0L;
            }
            if (timeWindow.getStartTimeDayOffsetMillis() <= dayTimeOffestMillis) continue;
            long timeMs = timeWindow.getStartTimeDayOffsetMillis() - dayTimeOffestMillis;
            if (result >= 0L && result <= timeMs) continue;
            result = timeMs;
        }
        return result;
    }

    @NotNull
    public final Set<DayOfWeek> component1() {
        return this.daysOfWeek;
    }

    private final Set<TimeWindow> component2() {
        return this._timeWindows;
    }

    @NotNull
    public final DaysOfWeekTimeWindows copy(@NotNull Set<? extends DayOfWeek> daysOfWeek, @NotNull Set<TimeWindow> _timeWindows) {
        Intrinsics.checkNotNullParameter(daysOfWeek, (String)"daysOfWeek");
        Intrinsics.checkNotNullParameter(_timeWindows, (String)"_timeWindows");
        return new DaysOfWeekTimeWindows(daysOfWeek, _timeWindows);
    }

    public static /* synthetic */ DaysOfWeekTimeWindows copy$default(DaysOfWeekTimeWindows daysOfWeekTimeWindows, Set set, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set = daysOfWeekTimeWindows.daysOfWeek;
        }
        if ((n & 2) != 0) {
            set2 = daysOfWeekTimeWindows._timeWindows;
        }
        return daysOfWeekTimeWindows.copy(set, set2);
    }

    @NotNull
    public String toString() {
        return "DaysOfWeekTimeWindows(daysOfWeek=" + this.daysOfWeek + ", _timeWindows=" + this._timeWindows + ')';
    }

    public int hashCode() {
        int result = ((Object)this.daysOfWeek).hashCode();
        result = result * 31 + ((Object)this._timeWindows).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DaysOfWeekTimeWindows)) {
            return false;
        }
        DaysOfWeekTimeWindows daysOfWeekTimeWindows = (DaysOfWeekTimeWindows)other;
        if (!Intrinsics.areEqual(this.daysOfWeek, daysOfWeekTimeWindows.daysOfWeek)) {
            return false;
        }
        return Intrinsics.areEqual(this._timeWindows, daysOfWeekTimeWindows._timeWindows);
    }
}

