/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.util.Random;

class SshDssPrivateKey
extends SshPrivateKey {
    DSAPrivateKey prvkey;

    public SshDssPrivateKey(DSAPrivateKey dSAPrivateKey) {
        this.prvkey = dSAPrivateKey;
    }

    public SshDssPrivateKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.prvkey = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshDssPrivateKey) {
            return this.prvkey.equals(((SshDssPrivateKey)object).prvkey);
        }
        return false;
    }

    public int hashCode() {
        return this.prvkey.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.prvkey.getX().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString("ssh-dss");
            byteArrayWriter.writeBigInteger(this.prvkey.getParams().getP());
            byteArrayWriter.writeBigInteger(this.prvkey.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.prvkey.getParams().getG());
            byteArrayWriter.writeBigInteger(this.prvkey.getX());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SshPublicKey getPublicKey() {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.getY(), this.prvkey.getParams().getP(), this.prvkey.getParams().getQ(), this.prvkey.getParams().getG());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return new SshDssPublicKey((DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] generateSignature(byte[] byArray) {
        try {
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(this.prvkey);
            Random random = new Random();
            byte[] byArray2 = new byte[20];
            random.nextBytes(byArray2);
            signature.update(byArray2);
            byte[] byArray3 = signature.sign();
            signature.update(byArray);
            byte[] byArray4 = signature.sign();
            byte[] byArray5 = new byte[40];
            byte by = byArray4[3];
            System.arraycopy(byArray4, 4 + (by - 20), byArray5, 0, 20);
            byte by2 = byArray4[4 + by + 1];
            System.arraycopy(byArray4, 4 + by + 2 + (by2 - 20), byArray5, 20, 20);
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBinaryString(byArray5);
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BigInteger getY() {
        return this.prvkey.getParams().getG().modPow(this.prvkey.getX(), this.prvkey.getParams().getP());
    }
}

