/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPrivateKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$SshAPIConfiguration;

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPrivateKeyFormat newInstance(String string) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(string)) {
                return (SshPrivateKeyFormat)((Class)formatTypes.get(string)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + string + " is not supported");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + string);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        formatTypes = new HashMap();
        log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory == null ? (class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory")) : class$com$sshtools$j2ssh$transport$publickey$SshPrivateKeyFormatFactory));
        types = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat == null ? (class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat")) : class$com$sshtools$j2ssh$transport$publickey$SshtoolsPrivateKeyFormat).getName());
        arrayList.add((class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat == null ? (class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.openssh.OpenSSHPrivateKeyFormat")) : class$com$sshtools$j2ssh$openssh$OpenSSHPrivateKeyFormat).getName());
        defaultFormat = "SSHTools-PrivateKey-Base64Encoded";
        try {
            if (ConfigurationLoader.isConfigurationAvailable(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration)) {
                object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshPrivateKeyFormatFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration);
                defaultFormat = object.getDefaultPrivateKeyFormat();
                arrayList.addAll(object.getPrivateKeyFormats());
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        log.debug((Object)("Default private key format will be " + defaultFormat));
        object = arrayList.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                Class clazz = ConfigurationLoader.getExtensionClass(string);
                SshPrivateKeyFormat sshPrivateKeyFormat = (SshPrivateKeyFormat)clazz.newInstance();
                log.debug((Object)("Installing " + sshPrivateKeyFormat.getFormatType() + " private key format"));
                formatTypes.put(sshPrivateKeyFormat.getFormatType(), clazz);
                types.add(sshPrivateKeyFormat.getFormatType());
            }
            catch (Exception exception) {
                log.warn((Object)("Private key format implemented by " + string + " will not be available"), (Throwable)exception);
            }
        }
    }
}

